/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.naming.NamingException;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesAnnotationHandler
implements AnnotationParser.AnnotationHandler {
    protected WebAppContext _wac;

    public ResourcesAnnotationHandler(WebAppContext wac) {
        this._wac = wac;
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotation, List<AnnotationParser.Value> values) {
        Class clazz = null;
        try {
            clazz = Loader.loadClass(null, (String)className);
        }
        catch (Exception e) {
            Log.warn((Throwable)e);
            return;
        }
        if (!Util.isServletType(clazz)) {
            Log.debug((String)("@Resources annotation ignored on on-servlet type class " + clazz.getName()));
            return;
        }
        Resources resources = clazz.getAnnotation(Resources.class);
        if (resources == null) {
            return;
        }
        Resource[] resArray = resources.value();
        if (resArray == null || resArray.length == 0) {
            return;
        }
        for (int j = 0; j < resArray.length; ++j) {
            String name = resArray[j].name();
            String mappedName = resArray[j].mappedName();
            Resource.AuthenticationType auth = resArray[j].authenticationType();
            Class type = resArray[j].type();
            boolean shareable = resArray[j].shareable();
            if (name == null || name.trim().equals("")) {
                Log.warn((String)"@Resource annotations on classes must contain a name (Common Annotations Spec Section 2.3)");
                break;
            }
            try {
                if (NamingEntryUtil.bindToENC((Object)this._wac, (String)name, (String)mappedName) || NamingEntryUtil.bindToENC((Object)this._wac.getServer(), (String)name, (String)mappedName)) continue;
                throw new IllegalStateException("No resource bound at " + (mappedName == null ? name : mappedName));
            }
            catch (NamingException e) {
                Log.warn((Throwable)e);
            }
        }
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)("@Resources not applicable for fields: " + className + "." + fieldName));
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)("@Resources not applicable for methods: " + className + "." + methodName));
    }
}

