/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.jetty.annotations.AnnotationFinder;
import org.eclipse.jetty.annotations.AnnotationProcessor;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.plus.servlet.ServletHandler;
import org.eclipse.jetty.plus.webapp.Configuration;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfiguration
extends Configuration {
    public static final String JAR_RESOURCES = "org.eclipse.jetty.jarList";

    public void parseAnnotations(WebAppContext context) throws Exception {
        AnnotationFinder finder = new AnnotationFinder();
        this.parseContainerPath(context, finder);
        this.parseWebInfLib(context, finder);
        this.parseWebInfClasses(context, finder);
        AnnotationProcessor processor = new AnnotationProcessor(context, finder);
        processor.process();
        List servlets = processor.getServlets();
        List filters = processor.getFilters();
        List servletMappings = processor.getServletMappings();
        List filterMappings = processor.getFilterMappings();
        List listeners = processor.getListeners();
        ServletHandler servletHandler = (ServletHandler)context.getServletHandler();
        servletHandler.setFilters((FilterHolder[])LazyList.toArray((Object)filters, FilterHolder.class));
        servletHandler.setFilterMappings((FilterMapping[])LazyList.toArray((Object)filterMappings, FilterMapping.class));
        servletHandler.setServlets((ServletHolder[])LazyList.toArray((Object)servlets, ServletHolder.class));
        servletHandler.setServletMappings((ServletMapping[])LazyList.toArray((Object)servletMappings, ServletMapping.class));
        context.setEventListeners((EventListener[])LazyList.toArray((Object)listeners, EventListener.class));
    }

    public void parseContainerPath(final WebAppContext context, AnnotationFinder finder) throws Exception {
        Log.debug((String)"Scanning container jars");
        ArrayList<URI> containerCandidateUris = this.findJars(context.getClassLoader().getParent(), true);
        ArrayList<URI> containerUris = new ArrayList<URI>();
        List jarResources = (List)context.getAttribute(JAR_RESOURCES);
        for (Resource r : jarResources) {
            URI uri = r.getURI();
            if (!containerCandidateUris.contains(uri)) continue;
            containerUris.add(uri);
        }
        finder.find(containerUris.toArray(new URI[containerUris.size()]), new ClassNameResolver(){

            public boolean isExcluded(String name) {
                if (context.isSystemClass(name)) {
                    return false;
                }
                return context.isServerClass(name);
            }

            public boolean shouldOverride(String name) {
                return context.isParentLoaderPriority();
            }
        });
    }

    public void parseWebInfLib(final WebAppContext context, AnnotationFinder finder) throws Exception {
        Log.debug((String)"Scanning WEB-INF/lib jars");
        ArrayList<URI> candidateUris = this.findJars(context.getClassLoader(), false);
        ArrayList<URI> webInfUris = new ArrayList<URI>();
        List jarResources = (List)context.getAttribute(JAR_RESOURCES);
        for (Resource r : jarResources) {
            URI uri = r.getURI();
            if (!candidateUris.contains(uri)) continue;
            webInfUris.add(uri);
        }
        finder.find(webInfUris.toArray(new URI[webInfUris.size()]), new ClassNameResolver(){

            public boolean isExcluded(String name) {
                if (context.isSystemClass(name)) {
                    return true;
                }
                if (context.isServerClass(name)) {
                    return false;
                }
                return false;
            }

            public boolean shouldOverride(String name) {
                return !context.isParentLoaderPriority();
            }
        });
    }

    public void parseWebInfClasses(final WebAppContext context, AnnotationFinder finder) throws Exception {
        Log.debug((String)"Scanning classes in WEB-INF/classes");
        finder.find(context.getWebInf().addPath("classes/"), new ClassNameResolver(){

            public boolean isExcluded(String name) {
                if (context.isSystemClass(name)) {
                    return true;
                }
                if (context.isServerClass(name)) {
                    return false;
                }
                return false;
            }

            public boolean shouldOverride(String name) {
                return !context.isParentLoaderPriority();
            }
        });
    }

    public ArrayList<URI> findJars(ClassLoader loader, boolean visitParent) {
        ArrayList<URI> uris = new ArrayList<URI>();
        while (loader != null && loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            if (urls != null) {
                for (URL u : urls) {
                    try {
                        uris.add(u.toURI());
                    }
                    catch (Exception e) {
                        Log.warn((Throwable)e);
                    }
                }
            }
            if (visitParent) {
                loader = loader.getParent();
                continue;
            }
            loader = null;
        }
        return uris;
    }
}

