/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.servlet.ServletInputStream;
import org.eclipse.jetty.ajp.Ajp13Generator;
import org.eclipse.jetty.ajp.Ajp13Parser;
import org.eclipse.jetty.ajp.Ajp13Request;
import org.eclipse.jetty.http.Generator;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.Parser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.BlockingHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;

public class Ajp13Connection
extends BlockingHttpConnection {
    public Ajp13Connection(Connector connector, EndPoint endPoint, Server server) {
        super(connector, endPoint, server, (Parser)new Ajp13Parser(connector.getRequestBuffers(), endPoint), (Generator)new Ajp13Generator(connector.getResponseBuffers(), endPoint), (Request)new Ajp13Request());
        ((Ajp13Parser)this._parser).setEventHandler(new RequestHandler());
        ((Ajp13Parser)this._parser).setGenerator((Ajp13Generator)this._generator);
        ((Ajp13Request)this._request).setConnection(this);
    }

    public boolean isConfidential(Request request) {
        return ((Ajp13Request)request).isSslSecure();
    }

    public boolean isIntegral(Request request) {
        return ((Ajp13Request)request).isSslSecure();
    }

    public ServletInputStream getInputStream() {
        if (this._in == null) {
            this._in = new Ajp13Parser.Input((Ajp13Parser)this._parser, this._connector.getMaxIdleTime());
        }
        return this._in;
    }

    private class RequestHandler
    implements Ajp13Parser.EventHandler {
        private RequestHandler() {
        }

        public void startForwardRequest() throws IOException {
            Ajp13Connection.this._uri.clear();
            ((Ajp13Request)Ajp13Connection.this._request).setSslSecure(false);
            Ajp13Connection.this._request.setTimeStamp(System.currentTimeMillis());
            Ajp13Connection.this._request.setUri(Ajp13Connection.this._uri);
        }

        public void parsedAuthorizationType(Buffer authType) throws IOException {
        }

        public void parsedRemoteUser(Buffer remoteUser) throws IOException {
            ((Ajp13Request)Ajp13Connection.this._request).setRemoteUser(remoteUser.toString());
        }

        public void parsedServletPath(Buffer servletPath) throws IOException {
            Ajp13Connection.this._request.setServletPath(servletPath.toString());
        }

        public void parsedContextPath(Buffer context) throws IOException {
            Ajp13Connection.this._request.setContextPath(context.toString());
        }

        public void parsedSslCert(Buffer sslCert) throws IOException {
            block3: {
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream bis = new ByteArrayInputStream(sslCert.toString().getBytes());
                    Collection<? extends Certificate> certCollection = cf.generateCertificates(bis);
                    X509Certificate[] certificates = new X509Certificate[certCollection.size()];
                    int i = 0;
                    for (Certificate certificate : certCollection) {
                        certificates[i++] = (X509Certificate)certificate;
                    }
                    Ajp13Connection.this._request.setAttribute("javax.servlet.request.X509Certificate", (Object)certificates);
                }
                catch (Exception e) {
                    Log.warn((String)e.toString());
                    Log.ignore((Throwable)e);
                    if (sslCert == null) break block3;
                    Ajp13Connection.this._request.setAttribute("javax.servlet.request.X509Certificate", (Object)sslCert.toString());
                }
            }
        }

        public void parsedSslCipher(Buffer sslCipher) throws IOException {
            Ajp13Connection.this._request.setAttribute("javax.servlet.request.cipher_suite", (Object)sslCipher.toString());
        }

        public void parsedSslSession(Buffer sslSession) throws IOException {
            Ajp13Connection.this._request.setAttribute("javax.servlet.request.ssl_session", (Object)sslSession.toString());
        }

        public void parsedSslKeySize(int keySize) throws IOException {
            Ajp13Connection.this._request.setAttribute("javax.servlet.request.key_size", (Object)new Integer(keySize));
        }

        public void parsedMethod(Buffer method) throws IOException {
            if (method == null) {
                throw new HttpException(400);
            }
            Ajp13Connection.this._request.setMethod(method.toString());
        }

        public void parsedUri(Buffer uri) throws IOException {
            Ajp13Connection.this._uri.parse(uri.toString());
        }

        public void parsedProtocol(Buffer protocol) throws IOException {
            if (protocol != null && protocol.length() > 0) {
                Ajp13Connection.this._request.setProtocol(protocol.toString());
            }
        }

        public void parsedRemoteAddr(Buffer addr) throws IOException {
            if (addr != null && addr.length() > 0) {
                Ajp13Connection.this._request.setRemoteAddr(addr.toString());
            }
        }

        public void parsedRemoteHost(Buffer name) throws IOException {
            if (name != null && name.length() > 0) {
                Ajp13Connection.this._request.setRemoteHost(name.toString());
            }
        }

        public void parsedServerName(Buffer name) throws IOException {
            if (name != null && name.length() > 0) {
                Ajp13Connection.this._request.setServerName(name.toString());
            }
        }

        public void parsedServerPort(int port) throws IOException {
            Ajp13Connection.this._request.setServerPort(port);
        }

        public void parsedSslSecure(boolean secure) throws IOException {
            ((Ajp13Request)Ajp13Connection.this._request).setSslSecure(secure);
        }

        public void parsedQueryString(Buffer value) throws IOException {
            String u = Ajp13Connection.this._uri + "?" + value;
            Ajp13Connection.this._uri.parse(u);
        }

        public void parsedHeader(Buffer name, Buffer value) throws IOException {
            Ajp13Connection.this._requestFields.add(name, value);
        }

        public void parsedRequestAttribute(String key, Buffer value) throws IOException {
            Ajp13Connection.this._request.setAttribute(key, (Object)value.toString());
        }

        public void parsedRequestAttribute(String key, int value) throws IOException {
            Ajp13Connection.this._request.setAttribute(key, (Object)Integer.toString(value));
        }

        public void headerComplete() throws IOException {
            Ajp13Connection.this.handleRequest();
        }

        public void messageComplete(long contextLength) throws IOException {
        }

        public void content(Buffer ref) throws IOException {
        }
    }
}

