/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http3.ControlFlusher;
import org.eclipse.jetty.http3.Grease;
import org.eclipse.jetty.http3.HTTP3Configuration;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.InstructionFlusher;
import org.eclipse.jetty.http3.InstructionHandler;
import org.eclipse.jetty.http3.MessageFlusher;
import org.eclipse.jetty.http3.StreamType;
import org.eclipse.jetty.http3.UnidirectionalStreamConnection;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.SettingsFrame;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.http3.qpack.QpackDecoder;
import org.eclipse.jetty.http3.qpack.QpackEncoder;
import org.eclipse.jetty.http3.server.internal.HTTP3SessionServer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.quic.api.Session;
import org.eclipse.jetty.quic.api.Stream;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.quic.server.ServerProtocolSession;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerHTTP3Session
extends ServerProtocolSession {
    private static final Logger LOG = LoggerFactory.getLogger(ServerHTTP3Session.class);
    private final HTTP3Configuration configuration;
    private final HTTP3SessionServer session;
    private final QpackEncoder encoder;
    private final QpackDecoder decoder;
    private final ControlFlusher controlFlusher;
    private final MessageFlusher messageFlusher;

    public ServerHTTP3Session(Connector connector, Session quicSession, ConnectionFactory connectionFactory, HTTP3Configuration configuration, Session.Server.Listener listener) {
        super(connector, quicSession, connectionFactory);
        this.configuration = configuration;
        this.session = new HTTP3SessionServer(connector.getScheduler(), this, listener);
        this.installBean((Object)this.session);
        this.session.setStreamIdleTimeout(configuration.getStreamIdleTimeout());
        if (LOG.isDebugEnabled()) {
            LOG.debug("initializing HTTP/3 streams");
        }
        ByteBufferPool byteBufferPool = connector.getByteBufferPool();
        long encoderStreamId = quicSession.newStreamId(false);
        StreamEndPoint encoderEndPoint = this.openInstructionEndPoint(encoderStreamId);
        InstructionFlusher encoderInstructionFlusher = new InstructionFlusher(byteBufferPool, encoderEndPoint, StreamType.ENCODER_STREAM);
        this.encoder = new QpackEncoder((Instruction.Handler)new InstructionHandler(encoderInstructionFlusher));
        this.encoder.setMaxHeadersSize(configuration.getMaxResponseHeadersSize());
        this.installBean(this.encoder);
        if (LOG.isDebugEnabled()) {
            LOG.debug("created encoder stream #{} on {}", (Object)encoderStreamId, (Object)encoderEndPoint);
        }
        long decoderStreamId = quicSession.newStreamId(false);
        StreamEndPoint decoderEndPoint = this.openInstructionEndPoint(decoderStreamId);
        InstructionFlusher decoderInstructionFlusher = new InstructionFlusher(byteBufferPool, decoderEndPoint, StreamType.DECODER_STREAM);
        this.decoder = new QpackDecoder((Instruction.Handler)new InstructionHandler(decoderInstructionFlusher));
        this.installBean(this.decoder);
        if (LOG.isDebugEnabled()) {
            LOG.debug("created decoder stream #{} on {}", (Object)decoderStreamId, (Object)decoderEndPoint);
        }
        long controlStreamId = quicSession.newStreamId(false);
        StreamEndPoint controlEndPoint = this.openControlEndPoint(controlStreamId);
        this.controlFlusher = new ControlFlusher(byteBufferPool, controlEndPoint, configuration.isUseOutputDirectByteBuffers());
        this.installBean(this.controlFlusher);
        if (LOG.isDebugEnabled()) {
            LOG.debug("created control stream #{} on {}", (Object)controlStreamId, (Object)controlEndPoint);
        }
        this.messageFlusher = new MessageFlusher(byteBufferPool, this.encoder, configuration.isUseOutputDirectByteBuffers());
        this.installBean(this.messageFlusher);
    }

    public QpackDecoder getQpackDecoder() {
        return this.decoder;
    }

    public QpackEncoder getQpackEncoder() {
        return this.encoder;
    }

    public HTTP3SessionServer getSessionServer() {
        return this.session;
    }

    protected void onStart() {
        HashMap<Long, Long> settings = this.session.onPreface();
        settings = settings != null ? new HashMap<Long, Long>(settings) : new HashMap();
        settings.compute(1L, (k, v) -> {
            if (v == null && (v = Long.valueOf(this.configuration.getMaxDecoderTableCapacity())) == 0L) {
                v = null;
            }
            return v;
        });
        settings.compute(6L, (k, v) -> {
            if (v == null && (v = Long.valueOf(this.configuration.getMaxRequestHeadersSize())) <= 0L) {
                v = null;
            }
            return v;
        });
        settings.compute(7L, (k, v) -> {
            if (v == null && (v = Long.valueOf(this.configuration.getMaxBlockedStreams())) == 0L) {
                v = null;
            }
            return v;
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("configuring decoder {} on {}", settings, (Object)this);
        }
        settings.forEach((key, value) -> {
            if (key == 1L) {
                this.decoder.setMaxTableCapacity(value.intValue());
            } else if (key == 6L) {
                this.decoder.setMaxHeadersSize(value.intValue());
            } else if (key == 7L) {
                this.decoder.setMaxBlockedStreams(value.intValue());
            }
        });
        SettingsFrame frame = new SettingsFrame(settings);
        if (this.controlFlusher.offer((Frame)frame, Callback.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, this.session::onOpen, this::failControlStream))) {
            this.controlFlusher.iterate();
        }
    }

    protected Connection newConnection(StreamEndPoint endPoint) throws IOException {
        if (endPoint.getStream().isBidirectional()) {
            return super.newConnection(endPoint);
        }
        return new UnidirectionalStreamConnection(endPoint, this.getExecutor(), this.getByteBufferPool(), this.getQpackEncoder(), this.getQpackDecoder(), this.session.getParserListener());
    }

    public void onSettings(SettingsFrame frame) {
        Map settings = frame.getSettings();
        if (LOG.isDebugEnabled()) {
            LOG.debug("configuring encoder {} on {}", (Object)settings, (Object)this);
        }
        settings.forEach((key, value) -> {
            if (key == 1L) {
                int maxTableCapacity = (int)Math.min(value, Integer.MAX_VALUE);
                this.encoder.setMaxTableCapacity(maxTableCapacity);
                this.encoder.setTableCapacity(Math.min(maxTableCapacity, this.configuration.getMaxEncoderTableCapacity()));
            } else if (key == 6L) {
                int maxHeadersSize = (int)Math.min(value, (long)this.configuration.getMaxResponseHeadersSize());
                this.encoder.setMaxHeadersSize(maxHeadersSize);
            } else if (key == 7L) {
                int maxBlockedStreams = (int)Math.min(value, Integer.MAX_VALUE);
                this.encoder.setMaxBlockedStreams(maxBlockedStreams);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("ignored {} setting {}={}", new Object[]{Grease.isGreaseValue((long)key) ? "grease" : "unknown", key, value});
            }
        });
    }

    private void failControlStream(Throwable failure) {
        long error = HTTP3ErrorCode.CLOSED_CRITICAL_STREAM_ERROR.code();
        this.onFailure(error, "control_stream_failure", failure);
    }

    private StreamEndPoint openInstructionEndPoint(long streamId) {
        Stream stream = this.getSession().newStream(streamId, null);
        return this.createStreamEndPoint(stream, StreamEndPoint::onOpen);
    }

    private StreamEndPoint openControlEndPoint(long streamId) {
        Stream stream = this.getSession().newStream(streamId, null);
        return this.createStreamEndPoint(stream, StreamEndPoint::onOpen);
    }

    public boolean onIdleTimeout(TimeoutException timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("idle timeout {} ms expired for {}", (Object)this.getSession().getIdleTimeout(), (Object)this);
        }
        return this.session.onIdleTimeout(timeout);
    }

    public void onStreamFailure(long streamId, Throwable failure) {
        this.session.onStreamFailure(streamId, HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), failure);
    }

    public void close(ConnectionCloseFrame frame, Promise.Invocable<ProtocolSession> promise) {
        this.session.close(frame.getErrorCode(), frame.getReason(), Promise.Invocable.toPromise(promise, s -> this));
    }

    private void onFailure(long error, String reason, Throwable failure) {
        this.session.onSessionFailure(error, reason, failure);
    }

    public CompletableFuture<ProtocolSession> shutdown() {
        return this.session.shutdown().thenApply(s -> this);
    }

    public void onClose(ConnectionCloseFrame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("session closed remotely {} {}", (Object)frame, (Object)this);
        }
        this.session.onClose(frame.getErrorCode(), frame.getReason());
    }

    void writeControlFrame(Frame frame, Callback callback) {
        if (this.controlFlusher.offer(frame, callback)) {
            this.controlFlusher.iterate();
        }
    }

    void writeMessageFrame(StreamEndPoint streamEndPoint, Frame frame, Callback callback) {
        if (this.messageFlusher.offer(streamEndPoint, frame, callback)) {
            this.messageFlusher.iterate();
        }
    }
}

