/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.instruction;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.compression.NBitIntegerEncoder;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;

public class InsertCountIncrementInstruction
implements Instruction {
    private final int _increment;

    public InsertCountIncrementInstruction(int increment) {
        this._increment = increment;
    }

    public int getIncrement() {
        return this._increment;
    }

    @Override
    public void encode(ByteBufferPool byteBufferPool, RetainableByteBuffer.Mutable accumulator) {
        int size = NBitIntegerEncoder.octetsNeeded((int)6, (long)this._increment);
        RetainableByteBuffer.Mutable retainableByteBuffer = byteBufferPool.acquire(size, true);
        ByteBuffer buffer = retainableByteBuffer.getByteBuffer();
        BufferUtil.clearToFill((ByteBuffer)buffer);
        buffer.put((byte)0);
        NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)6, (long)this._increment);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        accumulator.add((RetainableByteBuffer)retainableByteBuffer);
    }

    public String toString() {
        return String.format("%s@%x[increment=%d]", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getIncrement());
    }
}

