/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.compression.NBitIntegerEncoder;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.http3.qpack.QpackException;
import org.eclipse.jetty.http3.qpack.internal.EncodableEntry;
import org.eclipse.jetty.http3.qpack.internal.QpackContext;
import org.eclipse.jetty.http3.qpack.internal.StreamInfo;
import org.eclipse.jetty.http3.qpack.internal.instruction.DuplicateInstruction;
import org.eclipse.jetty.http3.qpack.internal.instruction.IndexedNameEntryInstruction;
import org.eclipse.jetty.http3.qpack.internal.instruction.LiteralNameEntryInstruction;
import org.eclipse.jetty.http3.qpack.internal.instruction.SetCapacityInstruction;
import org.eclipse.jetty.http3.qpack.internal.metadata.Http3Fields;
import org.eclipse.jetty.http3.qpack.internal.parser.EncoderInstructionParser;
import org.eclipse.jetty.http3.qpack.internal.table.DynamicTable;
import org.eclipse.jetty.http3.qpack.internal.table.Entry;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpackEncoder
implements Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(QpackEncoder.class);
    public static final EnumSet<HttpHeader> DO_NOT_HUFFMAN = EnumSet.of(HttpHeader.AUTHORIZATION, HttpHeader.CONTENT_MD5, HttpHeader.PROXY_AUTHENTICATE, HttpHeader.PROXY_AUTHORIZATION);
    public static final EnumSet<HttpHeader> DO_NOT_INDEX = EnumSet.of(HttpHeader.AUTHORIZATION, new HttpHeader[]{HttpHeader.CONTENT_MD5, HttpHeader.CONTENT_RANGE, HttpHeader.ETAG, HttpHeader.IF_MODIFIED_SINCE, HttpHeader.IF_UNMODIFIED_SINCE, HttpHeader.IF_NONE_MATCH, HttpHeader.IF_RANGE, HttpHeader.IF_MATCH, HttpHeader.LOCATION, HttpHeader.RANGE, HttpHeader.RETRY_AFTER, HttpHeader.LAST_MODIFIED, HttpHeader.SET_COOKIE, HttpHeader.SET_COOKIE2});
    public static final EnumSet<HttpHeader> NEVER_INDEX = EnumSet.of(HttpHeader.AUTHORIZATION, HttpHeader.SET_COOKIE, HttpHeader.SET_COOKIE2);
    private final AutoLock lock = new AutoLock();
    private final List<Instruction> _instructions = new ArrayList<Instruction>();
    private final Instruction.Handler _handler;
    private final QpackContext _context;
    private int _maxBlockedStreams;
    private final Map<Long, StreamInfo> _streamInfoMap = new HashMap<Long, StreamInfo>();
    private final EncoderInstructionParser _parser;
    private final InstructionHandler _instructionHandler = new InstructionHandler();
    private int _knownInsertCount;
    private int _blockedStreams;
    private int _maxHeadersSize = -1;
    private int _maxTableCapacity;

    public QpackEncoder(Instruction.Handler handler) {
        this._handler = handler;
        this._context = new QpackContext();
        this._parser = new EncoderInstructionParser(this._instructionHandler);
    }

    QpackContext getQpackContext() {
        return this._context;
    }

    Map<Long, StreamInfo> getStreamInfoMap() {
        return this._streamInfoMap;
    }

    public int getMaxBlockedStreams() {
        return this._maxBlockedStreams;
    }

    public void setMaxBlockedStreams(int maxBlockedStreams) {
        this._maxBlockedStreams = maxBlockedStreams;
    }

    public int getMaxHeadersSize() {
        return this._maxHeadersSize;
    }

    public void setMaxHeadersSize(int maxHeadersSize) {
        this._maxHeadersSize = maxHeadersSize;
    }

    public int getMaxTableCapacity() {
        return this._maxTableCapacity;
    }

    public void setMaxTableCapacity(int maxTableCapacity) {
        this._maxTableCapacity = maxTableCapacity;
        int capacity = this.getTableCapacity();
        if (capacity > maxTableCapacity) {
            this.setTableCapacity(maxTableCapacity);
        }
    }

    public int getTableCapacity() {
        return this._context.getDynamicTable().getCapacity();
    }

    public void setTableCapacity(int capacity) {
        try (AutoLock ignored = this.lock.lock();){
            if (capacity > this.getMaxTableCapacity()) {
                throw new IllegalArgumentException("DynamicTable capacity exceeds max capacity");
            }
            int oldCapacity = this._context.getDynamicTable().getCapacity();
            if (oldCapacity != capacity) {
                this._context.getDynamicTable().setCapacity(capacity);
                this._handler.onInstructions(List.of(new SetCapacityInstruction(capacity)));
                this.notifyInstructionHandler();
            }
        }
    }

    public void encode(ByteBuffer buffer, long streamId, MetaData metadata) throws QpackException {
        try (AutoLock ignored = this.lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("Encoding: streamId={}, metadata={}", (Object)streamId, (Object)metadata);
            }
            long totalSize = 0L;
            for (HttpField field : metadata.getHttpFields()) {
                HttpHeader header;
                String name = field.getLowerCaseName();
                if (!HttpTokens.isLegalH2H3FieldName((String)name) || name.charAt(0) == ':') {
                    throw new QpackException.StreamException(metadata.isRequest(), metadata.isResponse(), 270L, String.format("Invalid header name: '%s'", name));
                }
                String value = field.getValue();
                if (!HttpTokens.isLegalFieldValue((String)value)) {
                    throw new QpackException.StreamException(metadata.isRequest(), metadata.isResponse(), 270L, String.format("Invalid '%s' header value: '%s'", name, value));
                }
                if (this._maxHeadersSize <= 0 || (header = field.getHeader()) != null && header.isPseudo() || (totalSize += (long)(32 + name.length() + value.length())) <= (long)this._maxHeadersSize) continue;
                throw new QpackException.StreamException(metadata.isRequest(), metadata.isResponse(), 257L, String.format("Max size exceeded: %d > %d", totalSize, this._maxHeadersSize));
            }
            ArrayList<EncodableEntry> encodableEntries = new ArrayList<EncodableEntry>();
            DynamicTable dynamicTable = this._context.getDynamicTable();
            StreamInfo streamInfo = this._streamInfoMap.get(streamId);
            if (streamInfo == null) {
                streamInfo = new StreamInfo(streamId);
                this._streamInfoMap.put(streamId, streamInfo);
            }
            StreamInfo.SectionInfo sectionInfo = new StreamInfo.SectionInfo();
            streamInfo.add(sectionInfo);
            try {
                int requiredInsertCount = 0;
                Iterator<HttpField> iterator = new Http3Fields(metadata).iterator();
                while (iterator.hasNext()) {
                    HttpField field = iterator.next();
                    EncodableEntry entry = this.encode(streamInfo, field);
                    encodableEntries.add(entry);
                    int entryRequiredInsertCount = entry.getRequiredInsertCount();
                    if (entryRequiredInsertCount <= requiredInsertCount) continue;
                    requiredInsertCount = entryRequiredInsertCount;
                }
                sectionInfo.setRequiredInsertCount(requiredInsertCount);
                if (requiredInsertCount == 0) {
                    streamInfo.remove(sectionInfo);
                    if (streamInfo.isEmpty()) {
                        this._streamInfoMap.remove(streamId);
                    }
                }
                int base = dynamicTable.getBase();
                int encodedInsertCount = QpackEncoder.encodeInsertCount(requiredInsertCount, dynamicTable.getCapacity());
                boolean signBit = base < requiredInsertCount;
                int deltaBase = signBit ? requiredInsertCount - base - 1 : base - requiredInsertCount;
                NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)8, (long)encodedInsertCount);
                buffer.put(signBit ? (byte)-128 : 0);
                NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)7, (long)deltaBase);
                for (EncodableEntry entry : encodableEntries) {
                    entry.encode(buffer, base);
                }
                this.notifyInstructionHandler();
            }
            catch (BufferOverflowException e) {
                this.notifyInstructionHandler();
                streamInfo.remove(sectionInfo);
                sectionInfo.release();
                throw new QpackException.StreamException(metadata.isRequest(), metadata.isResponse(), 257L, "buffer_space_exceeded", e);
            }
            catch (Throwable t) {
                throw new QpackException.SessionException(257L, "compression_error", t);
            }
        }
    }

    public void parseInstructions(ByteBuffer buffer) throws QpackException {
        try (AutoLock ignored = this.lock.lock();){
            while (BufferUtil.hasContent((ByteBuffer)buffer)) {
                this._parser.parse(buffer);
            }
            this.notifyInstructionHandler();
        }
        catch (QpackException.SessionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new QpackException.SessionException(514L, t.getMessage(), t);
        }
    }

    public boolean insert(HttpField field) {
        try (AutoLock ignored = this.lock.lock();){
            boolean canCreateEntry;
            DynamicTable dynamicTable = this._context.getDynamicTable();
            boolean bl = canCreateEntry = this.shouldIndex(field) && dynamicTable.canInsert(field);
            if (!canCreateEntry) {
                boolean bl2 = false;
                return bl2;
            }
            Entry entry = this._context.get(field);
            if (entry != null) {
                int index = this._context.indexOf(entry);
                dynamicTable.add(new Entry(field));
                this._instructions.add(new DuplicateInstruction(index));
                this.notifyInstructionHandler();
                boolean bl3 = true;
                return bl3;
            }
            boolean huffman = this.shouldHuffmanEncode(field);
            Entry nameEntry = this._context.get(field.getLowerCaseName());
            if (nameEntry != null) {
                int index = this._context.indexOf(nameEntry);
                dynamicTable.add(new Entry(field));
                this._instructions.add(new IndexedNameEntryInstruction(!nameEntry.isStatic(), index, huffman, field.getValue()));
                this.notifyInstructionHandler();
                boolean bl4 = true;
                return bl4;
            }
            dynamicTable.add(new Entry(field));
            this._instructions.add(new LiteralNameEntryInstruction(field, huffman));
            this.notifyInstructionHandler();
            boolean bl5 = true;
            return bl5;
        }
    }

    public void streamCancellation(long streamId) {
        try (AutoLock ignored = this.lock.lock();){
            this._instructionHandler.onStreamCancellation(streamId);
            this.notifyInstructionHandler();
        }
    }

    protected boolean shouldIndex(HttpField httpField) {
        return !DO_NOT_INDEX.contains(httpField.getHeader());
    }

    protected boolean shouldHuffmanEncode(HttpField httpField) {
        return !DO_NOT_HUFFMAN.contains(httpField.getHeader());
    }

    private EncodableEntry encode(StreamInfo streamInfo, HttpField field) {
        DynamicTable dynamicTable = this._context.getDynamicTable();
        if (field instanceof PreEncodedHttpField) {
            return EncodableEntry.getPreEncodedEntry((PreEncodedHttpField)field);
        }
        boolean canCreateEntry = this.shouldIndex(field) && dynamicTable.canInsert(field);
        Entry entry = this._context.get(field);
        if (this.referenceEntry(entry, streamInfo)) {
            return EncodableEntry.getReferencedEntry(entry);
        }
        if (entry != null && canCreateEntry) {
            int index = this._context.indexOf(entry);
            Entry newEntry = new Entry(field);
            dynamicTable.add(newEntry);
            this._instructions.add(new DuplicateInstruction(index));
            if (this.referenceEntry(newEntry, streamInfo)) {
                return EncodableEntry.getReferencedEntry(newEntry);
            }
        }
        boolean huffman = this.shouldHuffmanEncode(field);
        Entry nameEntry = this._context.get(field.getLowerCaseName());
        if (this.referenceEntry(nameEntry, streamInfo)) {
            if (canCreateEntry) {
                int index = this._context.indexOf(nameEntry);
                Entry newEntry = new Entry(field);
                dynamicTable.add(newEntry);
                this._instructions.add(new IndexedNameEntryInstruction(!nameEntry.isStatic(), index, huffman, field.getValue()));
                if (this.referenceEntry(newEntry, streamInfo)) {
                    return EncodableEntry.getReferencedEntry(newEntry);
                }
            }
            return EncodableEntry.getNameReferencedEntry(nameEntry, field, huffman);
        }
        if (canCreateEntry) {
            Entry newEntry = new Entry(field);
            dynamicTable.add(newEntry);
            this._instructions.add(new LiteralNameEntryInstruction(field, huffman));
            if (this.referenceEntry(newEntry, streamInfo)) {
                return EncodableEntry.getReferencedEntry(newEntry);
            }
        }
        return EncodableEntry.getLiteralEntry(field, huffman);
    }

    private boolean referenceEntry(Entry entry, StreamInfo streamInfo) {
        boolean inEvictionZone;
        if (entry == null) {
            return false;
        }
        if (entry.isStatic()) {
            return true;
        }
        boolean bl = inEvictionZone = !this._context.getDynamicTable().canReference(entry);
        if (inEvictionZone) {
            return false;
        }
        StreamInfo.SectionInfo sectionInfo = streamInfo.getCurrentSectionInfo();
        if (this._knownInsertCount >= entry.getIndex() + 1) {
            sectionInfo.reference(entry);
            return true;
        }
        if (streamInfo.isBlocked()) {
            sectionInfo.block();
            sectionInfo.reference(entry);
            return true;
        }
        if (this._blockedStreams < this.getMaxBlockedStreams()) {
            ++this._blockedStreams;
            sectionInfo.block();
            sectionInfo.reference(entry);
            return true;
        }
        return false;
    }

    private static int encodeInsertCount(int reqInsertCount, int maxTableCapacity) {
        if (reqInsertCount == 0) {
            return 0;
        }
        int maxEntries = maxTableCapacity / 32;
        return reqInsertCount % (2 * maxEntries) + 1;
    }

    private void notifyInstructionHandler() {
        if (this._instructions.isEmpty()) {
            return;
        }
        List<Instruction> instructions = List.copyOf(this._instructions);
        this._instructions.clear();
        this._handler.onInstructions(instructions);
    }

    InstructionHandler getInstructionHandler() {
        return this._instructionHandler;
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this._context.getDynamicTable(), (Object[])new Object[0]);
    }

    class InstructionHandler
    implements EncoderInstructionParser.Handler {
        InstructionHandler() {
        }

        @Override
        public void onSectionAcknowledgement(long streamId) throws QpackException {
            StreamInfo streamInfo;
            if (LOG.isDebugEnabled()) {
                LOG.debug("SectionAcknowledgement: streamId={}", (Object)streamId);
            }
            if ((streamInfo = QpackEncoder.this._streamInfoMap.get(streamId)) == null) {
                throw new QpackException.SessionException(513L, "No StreamInfo for " + streamId);
            }
            StreamInfo.SectionInfo sectionInfo = streamInfo.acknowledge();
            boolean wasBlocked = sectionInfo.isBlocking();
            sectionInfo.release();
            QpackEncoder.this._knownInsertCount = Math.max(QpackEncoder.this._knownInsertCount, sectionInfo.getRequiredInsertCount());
            if (wasBlocked && !streamInfo.isBlocked()) {
                --QpackEncoder.this._blockedStreams;
            }
            if (streamInfo.isEmpty()) {
                QpackEncoder.this._streamInfoMap.remove(streamId);
            }
        }

        @Override
        public void onStreamCancellation(long streamId) {
            StreamInfo streamInfo;
            if (LOG.isDebugEnabled()) {
                LOG.debug("StreamCancellation: streamId={}", (Object)streamId);
            }
            if ((streamInfo = QpackEncoder.this._streamInfoMap.remove(streamId)) == null) {
                return;
            }
            for (StreamInfo.SectionInfo sectionInfo : streamInfo) {
                sectionInfo.release();
            }
        }

        @Override
        public void onInsertCountIncrement(int increment) throws QpackException {
            int insertCount;
            if (LOG.isDebugEnabled()) {
                LOG.debug("InsertCountIncrement: increment={}", (Object)increment);
            }
            if (QpackEncoder.this._knownInsertCount + increment > (insertCount = QpackEncoder.this._context.getDynamicTable().getInsertCount())) {
                throw new QpackException.SessionException(513L, "KnownInsertCount incremented over InsertCount");
            }
            QpackEncoder.this._knownInsertCount += increment;
        }
    }
}

