/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack;

public abstract class QpackException
extends Exception {
    public static final long QPACK_DECOMPRESSION_FAILED = 512L;
    public static final long QPACK_ENCODER_STREAM_ERROR = 513L;
    public static final long QPACK_DECODER_STREAM_ERROR = 514L;
    public static final long H3_GENERAL_PROTOCOL_ERROR = 257L;
    private final long _errorCode;

    QpackException(long errorCode, String message) {
        super(message);
        this._errorCode = errorCode;
    }

    QpackException(long errorCode, String message, Throwable cause) {
        super(message, cause);
        this._errorCode = errorCode;
    }

    public long getErrorCode() {
        return this._errorCode;
    }

    public static class SessionException
    extends QpackException {
        public SessionException(long errorCode, String message) {
            this(errorCode, message, null);
        }

        public SessionException(long errorCode, String message, Throwable cause) {
            super(errorCode, message, cause);
        }
    }

    public static class StreamException
    extends QpackException {
        private final boolean request;
        private final boolean response;

        public StreamException(boolean request, boolean response, long errorCode, String message) {
            super(errorCode, message);
            this.request = request;
            this.response = response;
        }

        public StreamException(boolean request, boolean response, long errorCode, String message, Throwable cause) {
            super(errorCode, message, cause);
            this.request = request;
            this.response = response;
        }

        public boolean isRequest() {
            return this.request;
        }

        public boolean isResponse() {
            return this.response;
        }
    }
}

