/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.util.EnumSet;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.HTTP3Exception;
import org.eclipse.jetty.http3.HTTP3Session;
import org.eclipse.jetty.http3.HTTP3StreamConnection;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTP3Stream
implements Stream,
CyclicTimeouts.Expirable,
Attachable {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3Stream.class);
    private final AutoLock lock = new AutoLock();
    private final HTTP3Session session;
    private final StreamEndPoint endPoint;
    private final boolean local;
    private CloseState closeState = CloseState.NOT_CLOSED;
    private FrameState frameState = FrameState.INITIAL;
    private long idleTimeout;
    private long expireNanoTime = Long.MAX_VALUE;
    private Object attachment;
    private boolean dataDemand;
    private boolean dataStalled = true;
    private boolean dataLast;
    private boolean dataAvailable;

    public HTTP3Stream(HTTP3Session session, StreamEndPoint endPoint, boolean local) {
        this.session = session;
        this.endPoint = endPoint;
        this.local = local;
    }

    public StreamEndPoint getStreamEndPoint() {
        return this.endPoint;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    @Override
    public long getId() {
        return this.endPoint.getStream().getId();
    }

    @Override
    public HTTP3Session getSession() {
        return this.session;
    }

    public boolean isLocal() {
        return this.local;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setting idle timeout {} ms for {}", (Object)idleTimeout, (Object)this);
        }
        this.idleTimeout = idleTimeout;
        this.notIdle();
        this.session.scheduleIdleTimeout(this);
    }

    public long getExpireNanoTime() {
        return this.expireNanoTime;
    }

    protected void notIdle() {
        this.expireNanoTime = CyclicTimeouts.Expirable.calcExpireNanoTime((long)this.getIdleTimeout());
    }

    void onIdleTimeout(TimeoutException timeout, Promise<Boolean> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("stream idle timeout {} ms expired on {}", (Object)this.getIdleTimeout(), (Object)this);
        }
        this.notifyIdleTimeout(timeout, (Promise<Boolean>)Promise.from(timedOut -> {
            if (timedOut.booleanValue()) {
                this.disconnect(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), timeout, (Promise.Invocable<Stream>)Promise.Invocable.noop());
            } else {
                this.notIdle();
            }
            promise.succeeded(timedOut);
        }, arg_0 -> promise.failed(arg_0)));
    }

    @Override
    public void data(DataFrame frame, Promise.Invocable<Stream> promise) {
        this.write(frame, promise);
    }

    protected void write(final Frame frame, final Promise.Invocable<Stream> promise) {
        this.writeFrame(frame, (Promise.Invocable<Stream>)new Promise.Invocable.Abstract<Stream>(this, promise.getInvocationType()){
            final /* synthetic */ HTTP3Stream this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            public void succeeded(Stream result) {
                this.this$0.updateClose(Frame.isLast(frame), true);
                promise.succeeded((Object)result);
            }

            public void failed(Throwable x) {
                this.this$0.updateClose(Frame.isLast(frame), true);
                Promise.Invocable p = Promise.Invocable.from((Invocable.InvocationType)this.getInvocationType(), s -> promise.failed(x), t -> promise.failed(x));
                this.this$0.disconnect(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), x, (Promise.Invocable<Stream>)p);
            }
        });
    }

    @Override
    public Content.Chunk read() {
        HTTP3StreamConnection connection = (HTTP3StreamConnection)this.endPoint.getConnection();
        Content.Chunk chunk = connection.read();
        if (LOG.isDebugEnabled()) {
            LOG.debug("read {} on {}", (Object)chunk, (Object)this);
        }
        try (AutoLock ignored = this.lock.lock();){
            this.dataAvailable = chunk != null;
            this.dataLast = chunk != null && chunk.isLast();
        }
        if (chunk != null) {
            this.updateClose(chunk.isLast(), false);
        }
        return chunk;
    }

    @Override
    public void demand() {
        boolean needsFillInterest;
        boolean process = false;
        try (AutoLock ignored = this.lock.lock();){
            this.dataDemand = true;
            boolean bl = needsFillInterest = !this.dataAvailable;
            if (this.dataStalled && this.dataAvailable || this.dataLast) {
                this.dataStalled = false;
                process = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("demand, process={} needsFillInterest={} on {}", new Object[]{process, needsFillInterest, this});
        }
        if (process) {
            this.processData(true);
        } else if (needsFillInterest) {
            HTTP3StreamConnection connection = (HTTP3StreamConnection)this.endPoint.getConnection();
            connection.fillInterested();
        }
    }

    void processData(boolean immediate) {
        boolean notify = true;
        while (true) {
            block10: {
                try (AutoLock ignored = this.lock.lock();){
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("processing demand={}, dataAvailable={} on {}", new Object[]{this.dataDemand, this.dataAvailable, this});
                    }
                    if ((this.dataAvailable || notify) && this.dataDemand) {
                        this.dataDemand = false;
                        this.dataStalled = false;
                        notify = false;
                        break block10;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stalling data processing for {}", (Object)this);
                    }
                    this.dataStalled = true;
                    return;
                }
            }
            this.onDataAvailable(immediate);
        }
    }

    @Override
    public void trailer(HeadersFrame frame, Promise.Invocable<Stream> promise) {
        if (!frame.isLast()) {
            promise.failed((Throwable)new IllegalArgumentException("invalid trailer frame: property 'last' must be true"));
            return;
        }
        this.write(frame, promise);
    }

    public boolean hasDemand() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.dataDemand;
            return bl;
        }
    }

    private boolean isStalled() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.dataStalled;
            return bl;
        }
    }

    private boolean isLast() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.dataLast;
            return bl;
        }
    }

    public void onHeaders(HeadersFrame frame) {
        this.notIdle();
        try (AutoLock ignored = this.lock.lock();){
            this.dataLast = frame.isLast();
            this.dataAvailable = !this.dataLast;
        }
    }

    public void onData(DataFrame ignored) {
        this.validateAndUpdate(EnumSet.of(FrameState.HEADER, FrameState.DATA), FrameState.DATA);
        this.notIdle();
    }

    private void onDataAvailable(boolean immediate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("notifying data available on {}", (Object)this);
        }
        this.notifyDataAvailable(immediate);
    }

    protected abstract void notifyDataAvailable(boolean var1);

    public void onTrailer(HeadersFrame frame) {
        Throwable failure = MetaData.Failed.getFailure((MetaData)frame.getMetaData());
        if (failure != null) {
            this.updateClose(true, false);
            this.onFailure(HTTP3ErrorCode.PROTOCOL_ERROR.code(), failure);
            return;
        }
        this.validateAndUpdate(EnumSet.of(FrameState.HEADER, FrameState.DATA), FrameState.TRAILER);
        this.notIdle();
        this.updateClose(frame.isLast(), false);
        this.notifyTrailer(frame);
    }

    protected abstract void notifyTrailer(HeadersFrame var1);

    protected abstract void notifyIdleTimeout(TimeoutException var1, Promise<Boolean> var2);

    public void onFailure(long error, Throwable failure) {
        this.notifyFailure(error, failure);
        this.disconnect(error, failure, (Promise.Invocable<Stream>)Promise.Invocable.noop());
    }

    public abstract void notifyFailure(long var1, Throwable var3);

    protected void validateAndUpdate(EnumSet<FrameState> allowed, FrameState target) {
        if (!allowed.contains((Object)this.frameState)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("invalid frame sequence, current={}, allowed={}, next={}", new Object[]{this.frameState, allowed, target});
            }
            this.frameState = FrameState.FAILED;
            throw new HTTP3Exception.SessionException(HTTP3ErrorCode.FRAME_UNEXPECTED_ERROR, "invalid_frame_sequence");
        }
        this.frameState = target;
    }

    public void writeFrame(Frame frame, Promise.Invocable<Stream> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing {} on {}", (Object)frame, (Object)this);
        }
        this.notIdle();
        this.session.writeMessageFrame(this.endPoint, frame, Promise.Invocable.toCallback(promise, (Object)this));
    }

    private CloseState getCloseState() {
        try (AutoLock ignored = this.lock.lock();){
            CloseState closeState = this.closeState;
            return closeState;
        }
    }

    public boolean isClosed() {
        return this.getCloseState() == CloseState.CLOSED;
    }

    public void updateClose(boolean update, boolean local) {
        if (!update) {
            return;
        }
        boolean remove = false;
        try (AutoLock ignored = this.lock.lock();){
            CloseState oldCloseState = this.closeState;
            switch (oldCloseState.ordinal()) {
                case 0: {
                    if (local) {
                        this.closeState = CloseState.LOCALLY_CLOSED;
                        break;
                    }
                    this.closeState = CloseState.REMOTELY_CLOSED;
                    break;
                }
                case 1: {
                    if (local) break;
                    this.closeState = CloseState.CLOSED;
                    remove = true;
                    break;
                }
                case 2: {
                    if (!local) break;
                    this.closeState = CloseState.CLOSED;
                    remove = true;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("updated close {}->{} on {}", new Object[]{oldCloseState, this.closeState, this});
            }
        }
        if (remove) {
            this.session.removeStream(this);
        }
    }

    @Override
    public void disconnect(long appErrorCode, Throwable failure, Promise.Invocable<Stream> promise) {
        this.disconnect(appErrorCode, failure, failure != null, promise);
    }

    private void disconnect(long appErrorCode, Throwable failure, boolean notifyFailure, Promise.Invocable<Stream> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("disconnecting with error 0x{} {} {}", new Object[]{Long.toHexString(appErrorCode), this, String.valueOf(failure)});
        }
        try (AutoLock ignored = this.lock.lock();){
            this.closeState = CloseState.CLOSED;
        }
        if (notifyFailure) {
            this.notifyFailure(appErrorCode, failure);
        }
        this.session.removeStream(this);
        HTTP3StreamConnection connection = (HTTP3StreamConnection)this.endPoint.getConnection();
        connection.disconnect(appErrorCode, failure, (Promise.Invocable<StreamEndPoint>)Promise.Invocable.toPromise(promise, streamEndPoint -> this));
    }

    public String toString() {
        return String.format("%s@%x#%d[%s,demand=%b,stalled=%b,last=%b,idle=%d/%d,session=%s]", new Object[]{TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getId(), this.getCloseState(), this.hasDemand(), this.isStalled(), this.isLast(), NanoTime.millisUntil((long)this.expireNanoTime), this.getIdleTimeout(), this.getSession()});
    }

    private static enum CloseState {
        NOT_CLOSED,
        LOCALLY_CLOSED,
        REMOTELY_CLOSED,
        CLOSED;

    }

    protected static enum FrameState {
        INITIAL,
        INFORMATIONAL,
        HEADER,
        DATA,
        TRAILER,
        FAILED;

    }
}

