/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.HTTP3Exception;
import org.eclipse.jetty.http3.HTTP3Stream;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.parser.MessageParser;
import org.eclipse.jetty.http3.parser.ParserListener;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTP3StreamConnection
extends AbstractConnection {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3StreamConnection.class);
    private final Callback fillableCallback = new FillableCallback();
    private final AtomicReference<FrameAction> frameAction = new AtomicReference();
    private final MessageParser parser;
    private HTTP3Stream stream;
    private Content.Chunk quicChunk;
    private boolean remotelyClosed;
    private boolean drivesFillInterest = true;
    private boolean trailerBlocked;

    public HTTP3StreamConnection(StreamEndPoint endPoint, Executor executor, MessageParser parser) {
        super((EndPoint)endPoint, executor);
        this.parser = parser;
        parser.init(x$0 -> new MessageListener((ParserListener)x$0));
    }

    public StreamEndPoint getEndPoint() {
        return (StreamEndPoint)super.getEndPoint();
    }

    void setStream(HTTP3Stream stream) {
        this.stream = stream;
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public void onClose(Throwable cause) {
        this.tryReleaseData(true);
        super.onClose(cause);
    }

    public void onFailure(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFailure on {}", (Object)this, (Object)failure);
        }
        this.tryReleaseData(true);
    }

    protected boolean onReadTimeout(TimeoutException timeout) {
        return false;
    }

    public void fillInterested() {
        this.fillInterested(this.fillableCallback);
    }

    public void onFillable() {
        this.processFrames(null);
    }

    private void processFrames(ParseResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processing frames, drivesFillInterest={} on {}", (Object)this.drivesFillInterest, (Object)this);
        }
        try {
            try {
                if (this.drivesFillInterest) {
                    while (true) {
                        boolean loop;
                        if (result == null) {
                            result = this.parseAndFill();
                        }
                        switch (result.ordinal()) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case 0: {
                                this.fillInterested();
                                boolean bl = false;
                                break;
                            }
                            case 1: {
                                boolean bl = false;
                                break;
                            }
                            case 2: {
                                HeadersFrame headers;
                                MetaData metaData;
                                FrameAction action = this.frameAction.getAndSet(null);
                                boolean interim = false;
                                Frame frame = action.frame();
                                if (frame instanceof HeadersFrame && (metaData = (headers = (HeadersFrame)frame).getMetaData()) instanceof MetaData.Response) {
                                    MetaData.Response response = (MetaData.Response)metaData;
                                    interim = HttpStatus.isInterim((int)response.getStatus());
                                }
                                this.drivesFillInterest = interim;
                                this.tryReleaseData(false);
                                action.task().run();
                                if (!interim) {
                                    this.stream.processData(false);
                                }
                                boolean bl = interim;
                                break;
                            }
                            case 3: {
                                boolean bl = loop = false;
                            }
                        }
                        if (loop) {
                            result = null;
                            continue;
                        }
                        break;
                    }
                } else {
                    if (result != null) {
                        Content.Chunk eof = this.read(result);
                        assert (eof == Content.Chunk.EOF);
                    }
                    this.stream.processData(true);
                }
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("failure processing frames on {}", (Object)this, (Object)x);
                }
                this.tryReleaseData(true);
                throw x;
            }
        }
        catch (HTTP3Exception.StreamException x) {
            this.parser.getListener().onStreamFailure(this.getEndPoint().getStream().getId(), x.getErrorCode(), x);
        }
        catch (HTTP3Exception.SessionException x) {
            this.parser.getListener().onSessionFailure(x.getErrorCode(), x.getReason(), x);
        }
        catch (Throwable x) {
            long error = HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code();
            this.parser.getListener().onStreamFailure(this.getEndPoint().getStream().getId(), error, x);
        }
    }

    Content.Chunk read() {
        return this.read(null);
    }

    private Content.Chunk read(ParseResult result) {
        try {
            Content.Chunk chunk;
            if (LOG.isDebugEnabled()) {
                LOG.debug("reading, resuming from blocked: {} on {}", (Object)(result != null ? 1 : 0), (Object)this);
            }
            if (result == null && this.trailerBlocked) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("reading null, trailer frame blocked on {}", (Object)this);
                }
                return null;
            }
            this.trailerBlocked = false;
            if (this.remotelyClosed) {
                return Content.Chunk.EOF;
            }
            if (result == null) {
                result = this.parseAndFill();
            }
            switch (result.ordinal()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 0: {
                    Content.Chunk chunk2 = null;
                    break;
                }
                case 1: {
                    this.trailerBlocked = true;
                    Content.Chunk chunk2 = null;
                    break;
                }
                case 2: {
                    Content.Chunk chunk2;
                    FrameAction action = this.frameAction.getAndSet(null);
                    action.task().run();
                    Frame frame = action.frame();
                    if (frame instanceof DataFrame) {
                        DataFrame dataFrame = (DataFrame)frame;
                        if (dataFrame.isLast() && !dataFrame.getByteBuffer().hasRemaining()) {
                            this.tryReleaseData(true);
                            chunk2 = Content.Chunk.EOF;
                            break;
                        }
                        Content.Chunk h3Chunk = Content.Chunk.asChunk((ByteBuffer)dataFrame.getByteBuffer(), (boolean)dataFrame.isLast(), (Retainable)this.quicChunk);
                        h3Chunk.retain();
                        if (h3Chunk.isLast()) {
                            this.tryReleaseData(true);
                        }
                        chunk2 = h3Chunk;
                        break;
                    }
                    this.tryReleaseData(true);
                    chunk2 = Content.Chunk.EOF;
                    break;
                }
                case 3: {
                    Content.Chunk chunk2 = chunk = Content.Chunk.EOF;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("read {} on {}", (Object)chunk, (Object)this);
            }
            return chunk;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("failure reading data on {}", (Object)this, (Object)x);
            }
            this.tryReleaseData(true);
            return Content.Chunk.from((Throwable)x);
        }
    }

    private ParseResult parseAndFill() {
        try {
            Enum result;
            if (LOG.isDebugEnabled()) {
                LOG.debug("parse+fill on {}", (Object)this);
            }
            do {
                if (this.quicChunk != null) {
                    result = this.parser.parse(this.quicChunk.getByteBuffer(), this.quicChunk.isLast());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("parsed {} from {} on {}", new Object[]{result, this.quicChunk, this});
                    }
                    if (result == MessageParser.Result.FRAME) {
                        return ParseResult.FRAME;
                    }
                    if (result == MessageParser.Result.BLOCKED_FRAME) {
                        return ParseResult.BLOCKED_FRAME;
                    }
                    this.tryReleaseData(true);
                }
                this.quicChunk = this.getEndPoint().fill();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("filled {} on {}", (Object)this.quicChunk, (Object)this);
                }
                if (this.quicChunk != null) continue;
                return ParseResult.NO_FRAME;
            } while (this.quicChunk.hasRemaining());
            if (Content.Chunk.isFailure((Content.Chunk)this.quicChunk)) {
                throw new UncheckedIOException(IO.rethrow((Throwable)this.quicChunk.getFailure()));
            }
            result = this.quicChunk.isLast() ? ParseResult.EOF : ParseResult.NO_FRAME;
            this.tryReleaseData(true);
            return result;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("parse+fill failure on {}", (Object)this, (Object)x);
            }
            throw x;
        }
    }

    private void processHeaders(HeadersFrame frame, boolean wasBlocked, Runnable delegate) {
        MetaData metaData;
        if (LOG.isDebugEnabled()) {
            LOG.debug("processing {} wasBlocked={} on {}", new Object[]{frame, wasBlocked, this});
        }
        if (!((metaData = frame.getMetaData()).isRequest() || metaData.isResponse() || frame.isLast())) {
            frame = new HeadersFrame(metaData, true);
        }
        if (frame.isLast()) {
            this.shutdownInput();
        }
        delegate.run();
    }

    private void processData(DataFrame frame, Runnable delegate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("processing {} on {}", (Object)frame, (Object)this);
        }
        if (frame.isLast()) {
            this.shutdownInput();
        }
        delegate.run();
    }

    private void shutdownInput() {
        this.remotelyClosed = true;
        this.getEndPoint().shutdownInput(HTTP3ErrorCode.NO_ERROR.code());
    }

    void disconnect(long appErrorCode, Throwable failure, Promise.Invocable<StreamEndPoint> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("disconnecting with error 0x{} {} {}", new Object[]{Long.toHexString(appErrorCode), this, String.valueOf(failure)});
        }
        this.tryReleaseData(true);
        this.getEndPoint().disconnect(appErrorCode, failure, true, promise);
    }

    private void tryReleaseData(boolean force) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("releasing force={} {} on {}", new Object[]{force, this.quicChunk, this});
        }
        if (this.quicChunk == null) {
            return;
        }
        if (force || this.quicChunk.isLast() && !this.quicChunk.hasRemaining()) {
            this.quicChunk.release();
            this.quicChunk = null;
        }
    }

    public String toConnectionString() {
        return String.format("%s[stream=%s]", super.toConnectionString(), this.stream);
    }

    private class FillableCallback
    implements Callback {
        private FillableCallback() {
        }

        public void succeeded() {
            HTTP3StreamConnection.this.onFillable();
        }

        public void failed(Throwable x) {
            HTTP3StreamConnection.this.onFillInterestedFailed(x);
        }

        public Invocable.InvocationType getInvocationType() {
            HTTP3Stream http3Stream = HTTP3StreamConnection.this.stream;
            return http3Stream == null ? Invocable.InvocationType.BLOCKING : Invocable.getInvocationType((Object)http3Stream);
        }

        public String toString() {
            return "%s@%x[%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getInvocationType());
        }
    }

    private static enum ParseResult {
        NO_FRAME,
        BLOCKED_FRAME,
        FRAME,
        EOF;

    }

    private record FrameAction(Frame frame, Runnable task) {
    }

    private class MessageListener
    extends ParserListener.Wrapper {
        private MessageListener(ParserListener listener) {
            super(listener);
        }

        @Override
        public void onHeaders(long streamId, HeadersFrame frame, boolean wasBlocked) {
            Runnable delegate;
            Runnable task;
            if (LOG.isDebugEnabled()) {
                LOG.debug("received {}#{} wasBlocked={}", new Object[]{frame, streamId, wasBlocked});
            }
            if (!HTTP3StreamConnection.this.frameAction.compareAndSet(null, new FrameAction(frame, task = () -> this.lambda$onHeaders$1(frame, wasBlocked, delegate = () -> super.onHeaders(streamId, frame, wasBlocked))))) {
                throw new IllegalStateException();
            }
            if (wasBlocked) {
                HTTP3StreamConnection.this.processFrames(ParseResult.FRAME);
            }
        }

        @Override
        public void onData(long streamId, DataFrame frame) {
            Runnable delegate;
            Runnable task;
            if (LOG.isDebugEnabled()) {
                LOG.debug("received {}#{}", (Object)frame, (Object)streamId);
            }
            if (!HTTP3StreamConnection.this.frameAction.compareAndSet(null, new FrameAction(frame, task = () -> this.lambda$onData$3(frame, delegate = () -> super.onData(streamId, frame))))) {
                throw new IllegalStateException();
            }
        }

        private /* synthetic */ void lambda$onData$3(DataFrame frame, Runnable delegate) {
            HTTP3StreamConnection.this.processData(frame, delegate);
        }

        private /* synthetic */ void lambda$onHeaders$1(HeadersFrame frame, boolean wasBlocked, Runnable delegate) {
            HTTP3StreamConnection.this.processHeaders(frame, wasBlocked, delegate);
        }
    }
}

