/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.HTTP3Exception;
import org.eclipse.jetty.http3.HTTP3Stream;
import org.eclipse.jetty.http3.HTTP3StreamConnection;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.GoAwayFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.frames.SettingsFrame;
import org.eclipse.jetty.http3.parser.ParserListener;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.StreamEndPoint;
import org.eclipse.jetty.util.Atomics;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTP3Session
extends ContainerLifeCycle
implements Session {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3Session.class);
    private final AutoLock lock = new AutoLock();
    private final AtomicLong lastStreamId = new AtomicLong(0L);
    private final Map<Long, HTTP3Stream> streams = new ConcurrentHashMap<Long, HTTP3Stream>();
    private final ProtocolSession session;
    private final Session.Listener listener;
    private final AtomicInteger streamCount = new AtomicInteger();
    private final StreamTimeouts streamTimeouts;
    private final ParserListener parserListener;
    private long streamIdleTimeout;
    private CloseState closeState = CloseState.CLOSED;
    private GoAwayFrame goAwaySent;
    private GoAwayFrame goAwayRecv;
    private Runnable zeroStreamsAction;
    private CompletableFuture<Session> shutdown;

    public HTTP3Session(Scheduler scheduler, ProtocolSession session, Session.Listener listener) {
        this.session = session;
        this.listener = listener;
        this.streamTimeouts = new StreamTimeouts(scheduler);
        this.parserListener = new FrameListener();
    }

    public ProtocolSession getProtocolSession() {
        return this.session;
    }

    public Session.Listener getListener() {
        return this.listener;
    }

    public ParserListener getParserListener() {
        return this.parserListener;
    }

    public void onOpen() {
        this.closeState = CloseState.NOT_CLOSED;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.getProtocolSession().getSession().getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.getProtocolSession().getSession().getRemoteSocketAddress();
    }

    @Override
    public Collection<Stream> getStreams() {
        return List.copyOf(this.streams.values());
    }

    public long getMaxLocalStreams() {
        return this.session.getSession().getLocalBidirectionalMaxStreams();
    }

    @Override
    public void goAway(boolean graceful, Promise.Invocable<Session> promise) {
        this.goAway(this.newGoAwayFrame(graceful), promise);
    }

    /*
     * Unable to fully structure code
     */
    private void goAway(GoAwayFrame frame, Promise.Invocable<Session> promise) {
        if (HTTP3Session.LOG.isDebugEnabled()) {
            HTTP3Session.LOG.debug("goAway with {} on {}", (Object)frame, (Object)this);
        }
        failStreams = false;
        sendGoAway = false;
        ignored = this.lock.lock();
        try {
            switch (this.closeState.ordinal()) {
                case 0: {
                    this.goAwaySent = frame;
                    sendGoAway = true;
                    this.closeState = CloseState.LOCALLY_CLOSED;
                    if (frame.isGraceful()) {
                        this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$goAway$0(), ()V)((HTTP3Session)this);
                        ** break;
                    }
lbl15:
                    // 3 sources

                    break;
                }
                case 1: {
                    if (frame.isGraceful()) {
                        if (HTTP3Session.LOG.isDebugEnabled()) {
                            HTTP3Session.LOG.debug("already sent {} on {}", (Object)this.goAwaySent, (Object)this);
                            ** break;
                        }
lbl21:
                        // 3 sources

                    } else if (this.goAwaySent.isGraceful() || frame.getLastId() < this.goAwaySent.getLastId()) {
                        this.goAwaySent = frame;
                        sendGoAway = true;
                        ** break;
lbl26:
                        // 1 sources

                    } else {
                        this.closeState = CloseState.CLOSED;
                        failStreams = true;
                        ** break;
                    }
lbl30:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.goAwaySent = frame;
                    sendGoAway = true;
                    if (frame.isGraceful()) {
                        this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$goAway$1(), ()V)((HTTP3Session)this);
                        ** break;
lbl37:
                        // 1 sources

                    } else if (this.goAwayRecv.isGraceful()) {
                        if (HTTP3Session.LOG.isDebugEnabled()) {
                            HTTP3Session.LOG.debug("waiting non-graceful GOAWAY on {}", (Object)this);
                            ** break;
                        }
lbl42:
                        // 3 sources

                    } else {
                        this.closeState = CloseState.CLOSING;
                        this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, terminate(), ()V)((HTTP3Session)this);
                        ** break;
                    }
lbl46:
                    // 1 sources

                    break;
                }
                case 3: 
                case 4: {
                    if (HTTP3Session.LOG.isDebugEnabled()) {
                        HTTP3Session.LOG.debug("already closed on {}", (Object)this);
                        ** break;
                    }
lbl51:
                    // 3 sources

                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        if (sendGoAway) {
            this.writeControlFrame(frame, Callback.from((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, tryRunZeroStreamsAction(), ()V)((HTTP3Session)this), (Callback)Promise.Invocable.toCallback(promise, (Object)this)));
        } else if (failStreams) {
            error = HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code();
            this.failStreams((Predicate<HTTP3Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$goAway$2(org.eclipse.jetty.http3.HTTP3Stream ), (Lorg/eclipse/jetty/http3/HTTP3Stream;)Z)(), error, new ClosedChannelException());
            this.terminateAndDisconnect(error, "go_away", promise);
        } else {
            promise.succeeded((Object)this);
        }
    }

    protected GoAwayFrame newGoAwayFrame(boolean graceful) {
        return new GoAwayFrame(this.lastStreamId.get());
    }

    public CompletableFuture<Session> shutdown() {
        Promise.Completable result;
        try (AutoLock ignored = this.lock.lock();){
            if (this.shutdown != null) {
                CompletableFuture<Session> completableFuture = this.shutdown;
                return completableFuture;
            }
            this.shutdown = result = new Promise.Completable();
        }
        this.goAway(true, (Promise.Invocable<Session>)Promise.Invocable.noop());
        return result;
    }

    private void updateLastStreamId(long id) {
        Atomics.updateMax((AtomicLong)this.lastStreamId, (long)id);
    }

    public long getIdleTimeout() {
        return this.getProtocolSession().getSession().getIdleTimeout();
    }

    public long getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    public void setStreamIdleTimeout(long streamIdleTimeout) {
        this.streamIdleTimeout = streamIdleTimeout;
    }

    void scheduleIdleTimeout(HTTP3Stream stream) {
        this.streamTimeouts.schedule(stream);
    }

    protected HTTP3Stream createStream(StreamEndPoint endPoint) {
        long streamId = endPoint.getStream().getId();
        return this.streams.compute(streamId, (id, stream) -> {
            if (stream != null) {
                throw new HTTP3Exception.StreamException(HTTP3ErrorCode.REQUEST_REJECTED_ERROR, "duplicate_stream_id");
            }
            return this.createHTTP3Stream(endPoint, true);
        });
    }

    private HTTP3Stream createHTTP3Stream(StreamEndPoint endPoint, boolean local) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.closeState == CloseState.LOCALLY_CLOSED) {
                if (endPoint.getStream().getId() > this.goAwaySent.getLastId()) {
                    throw new HTTP3Exception.StreamException(HTTP3ErrorCode.REQUEST_REJECTED_ERROR, "goaway_sent");
                }
            } else if (this.closeState != CloseState.NOT_CLOSED) {
                throw new HTTP3Exception.SessionException(HTTP3ErrorCode.REQUEST_REJECTED_ERROR, "session_closed");
            }
            this.streamCount.incrementAndGet();
        }
        HTTP3Stream stream = this.newHTTP3Stream(endPoint, local);
        ((HTTP3StreamConnection)endPoint.getConnection()).setStream(stream);
        endPoint.setIdleTimeout(0L);
        long idleTimeout = this.getStreamIdleTimeout();
        if (idleTimeout > 0L) {
            stream.setIdleTimeout(idleTimeout);
        }
        if (!local) {
            this.updateLastStreamId(stream.getId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("created {}", (Object)stream);
        }
        return stream;
    }

    protected abstract HTTP3Stream newHTTP3Stream(StreamEndPoint var1, boolean var2);

    protected HTTP3Stream getStream(long streamId) {
        return this.streams.get(streamId);
    }

    void removeStream(HTTP3Stream stream) {
        boolean removed;
        boolean bl = removed = this.streams.remove(stream.getId()) != null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("removed {} {} on {}", new Object[]{removed, stream, this});
        }
        if (removed) {
            this.getProtocolSession().removeStreamEndPoint(stream.getStreamEndPoint());
            if (this.streamCount.decrementAndGet() == 0) {
                this.tryRunZeroStreamsAction();
            }
        }
    }

    public abstract void writeControlFrame(Frame var1, Callback var2);

    public abstract void writeMessageFrame(StreamEndPoint var1, Frame var2, Callback var3);

    public Map<Long, Long> onPreface() {
        Map<Long, Long> settings = this.notifyPreface();
        if (LOG.isDebugEnabled()) {
            LOG.debug("application produced settings {} on {}", settings, (Object)this);
        }
        return settings;
    }

    private Map<Long, Long> notifyPreface() {
        try {
            return this.listener.onPreface(this);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)this.listener, (Object)x);
            return null;
        }
    }

    private void notifySettings(SettingsFrame frame) {
        try {
            this.listener.onSettings(this, frame);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    private void notifyGoAway(GoAwayFrame frame) {
        try {
            this.listener.onGoAway(this, frame);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    private boolean notifyIdleTimeout() {
        try {
            return this.listener.onIdleTimeout(this);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)this.listener, (Object)x);
            return true;
        }
    }

    protected void onHeaders(long streamId, HeadersFrame frame, boolean wasBlocked) {
        MetaData metaData = frame.getMetaData();
        if (metaData.isRequest() || metaData.isResponse()) {
            throw new HTTP3Exception.StreamException(HTTP3ErrorCode.REQUEST_REJECTED_ERROR, "invalid_metadata");
        }
        StreamEndPoint endPoint = this.session.getStreamEndPoint(streamId);
        HTTP3Stream stream = this.getStream(endPoint.getStream().getId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("received trailer {} on {}", (Object)frame, (Object)stream);
        }
        if (stream == null) {
            throw new HTTP3Exception.SessionException(HTTP3ErrorCode.FRAME_UNEXPECTED_ERROR.code(), "invalid_frame_sequence");
        }
        stream.onTrailer(frame);
    }

    protected void onData(long streamId, DataFrame frame) {
        HTTP3Stream stream = this.getStream(streamId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("received {} on {}", (Object)frame, (Object)stream);
        }
        if (stream == null) {
            throw new HTTP3Exception.SessionException(HTTP3ErrorCode.FRAME_UNEXPECTED_ERROR.code(), "invalid_frame_sequence");
        }
        stream.onData(frame);
    }

    protected void onSettings(SettingsFrame frame) {
        this.notifySettings(frame);
    }

    /*
     * Unable to fully structure code
     */
    protected void onGoAway(GoAwayFrame frame) {
        if (HTTP3Session.LOG.isDebugEnabled()) {
            HTTP3Session.LOG.debug("received {} on {}", (Object)frame, (Object)this);
        }
        failStreams = false;
        ignored = this.lock.lock();
        try {
            switch (this.closeState.ordinal()) {
                case 0: {
                    this.goAwayRecv = frame;
                    if (frame.isGraceful()) {
                        this.closeState = CloseState.REMOTELY_CLOSED;
                        if (HTTP3Session.LOG.isDebugEnabled()) {
                            HTTP3Session.LOG.debug("waiting non-graceful GOAWAY on {}", (Object)this);
                            ** break;
                        }
lbl14:
                        // 3 sources

                    } else {
                        this.goAwaySent = this.newGoAwayFrame(false);
                        this.closeState = CloseState.CLOSING;
                        goAwayFrame = this.goAwaySent;
                        this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onGoAway$4(org.eclipse.jetty.http3.frames.GoAwayFrame ), ()V)((HTTP3Session)this, (GoAwayFrame)goAwayFrame);
                        failStreams = true;
                        ** break;
                    }
lbl21:
                    // 1 sources

                    break;
                }
                case 1: {
                    this.goAwayRecv = frame;
                    if (frame.isGraceful()) {
                        if (HTTP3Session.LOG.isDebugEnabled()) {
                            HTTP3Session.LOG.debug("waiting non-graceful GOAWAY on {}", (Object)this);
                            ** break;
                        }
lbl28:
                        // 3 sources

                    } else {
                        this.closeState = CloseState.CLOSING;
                        if (this.goAwaySent.isGraceful()) {
                            goAwayFrame = this.goAwaySent = this.newGoAwayFrame(false);
                            this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onGoAway$6(org.eclipse.jetty.http3.frames.GoAwayFrame ), ()V)((HTTP3Session)this, (GoAwayFrame)goAwayFrame);
                            ** break;
lbl34:
                            // 1 sources

                        } else {
                            this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onGoAway$7(), ()V)((HTTP3Session)this);
                            failStreams = true;
                            ** break;
                        }
                    }
lbl38:
                    // 1 sources

                    break;
                }
                case 2: {
                    if (frame.isGraceful()) {
                        if (HTTP3Session.LOG.isDebugEnabled()) {
                            HTTP3Session.LOG.debug("already received {} on {}", (Object)this.goAwayRecv, (Object)this);
                            ** break;
                        }
lbl44:
                        // 3 sources

                    } else {
                        this.goAwayRecv = frame;
                        this.closeState = CloseState.CLOSING;
                        if (this.goAwaySent == null || this.goAwaySent.isGraceful()) {
                            goAwayFrame = this.goAwaySent = this.newGoAwayFrame(false);
                            this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onGoAway$8(org.eclipse.jetty.http3.frames.GoAwayFrame ), ()V)((HTTP3Session)this, (GoAwayFrame)goAwayFrame);
                        } else {
                            this.zeroStreamsAction = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, terminate(), ()V)((HTTP3Session)this);
                        }
                        failStreams = true;
                        ** break;
                    }
lbl54:
                    // 1 sources

                    break;
                }
                case 3: 
                case 4: {
                    if (HTTP3Session.LOG.isDebugEnabled()) {
                        HTTP3Session.LOG.debug("already closed on {}", (Object)this);
                        ** break;
                    }
lbl59:
                    // 3 sources

                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        this.notifyGoAway(frame);
        if (failStreams) {
            predicate = (Predicate<HTTP3Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$onGoAway$9(org.eclipse.jetty.http3.frames.GoAwayFrame org.eclipse.jetty.http3.HTTP3Stream ), (Lorg/eclipse/jetty/http3/HTTP3Stream;)Z)((GoAwayFrame)frame);
            this.failStreams(predicate, HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), (Throwable)new EofException());
        }
        this.tryRunZeroStreamsAction();
    }

    public void onStreamFailure(long streamId, long error, Throwable failure) {
        HTTP3Stream stream;
        if (LOG.isDebugEnabled()) {
            LOG.debug("stream failure 0x{}/{} for stream #{} on {}", new Object[]{Long.toHexString(error), failure.getMessage(), streamId, this});
        }
        if ((stream = this.getStream(streamId)) != null) {
            stream.onFailure(error, failure);
        } else {
            StreamEndPoint endPoint = this.session.getStreamEndPoint(streamId);
            if (endPoint != null) {
                endPoint.disconnect(error, failure, true, Promise.Invocable.noop());
            }
        }
    }

    public void onSessionFailure(long error, String reason, Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("session failure 0x{}/{} on {}", new Object[]{Long.toHexString(error), failure.getMessage(), this});
        }
        this.notifyFailure(error, reason, failure);
        this.close(error, reason, (Promise.Invocable<Session>)Promise.Invocable.noop());
    }

    /*
     * Unable to fully structure code
     */
    public boolean onIdleTimeout(TimeoutException timeout) {
        notify = false;
        terminate = false;
        ignored = this.lock.lock();
        try {
            switch (this.closeState.ordinal()) {
                case 0: {
                    notify = true;
                    ** break;
lbl9:
                    // 1 sources

                    break;
                }
                case 3: 
                case 4: {
                    terminate = true;
                    break;
                }
                ** default:
lbl14:
                // 1 sources

                break;
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        if (terminate) {
            if (HTTP3Session.LOG.isDebugEnabled()) {
                HTTP3Session.LOG.debug("already closed, ignored idle timeout for {}", (Object)this);
            }
            this.terminateAndDisconnect(HTTP3ErrorCode.NO_ERROR.code(), "idle_timeout", (Promise.Invocable<Session>)Promise.Invocable.noop());
            return false;
        }
        confirmed = true;
        if (notify) {
            confirmed = this.notifyIdleTimeout();
        }
        if (HTTP3Session.LOG.isDebugEnabled()) {
            HTTP3Session.LOG.debug("idle timeout {} for {}", (Object)(confirmed != false ? "confirmed" : "ignored"), (Object)this);
        }
        if (!confirmed) {
            return false;
        }
        this.close(HTTP3ErrorCode.NO_ERROR.code(), "idle_timeout", (Promise.Invocable<Session>)Promise.Invocable.noop());
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void close(long error, String reason, Promise.Invocable<Session> promise) {
        goAwayFrame = null;
        ignored = this.lock.lock();
        try {
            switch (this.closeState.ordinal()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (this.goAwaySent == null || this.goAwaySent.isGraceful()) {
                        this.goAwaySent = goAwayFrame = this.newGoAwayFrame(false);
                    }
                    this.closeState = CloseState.CLOSED;
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 4: {
                    promise.succeeded((Object)this);
                    return;
                }
                default: {
                    promise.failed((Throwable)new IllegalStateException());
                    return;
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        this.failStreams((Predicate<HTTP3Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$close$10(org.eclipse.jetty.http3.HTTP3Stream ), (Lorg/eclipse/jetty/http3/HTTP3Stream;)Z)(), error, new IOException(reason));
        if (goAwayFrame != null) {
            this.writeControlFrame(goAwayFrame, Callback.from((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$close$11(long java.lang.String org.eclipse.jetty.util.Promise$Invocable ), ()V)((HTTP3Session)this, (long)error, (String)reason, promise)));
        } else {
            this.terminateAndDisconnect(error, reason, promise);
        }
    }

    private void terminateAndDisconnect(long error, String reason, Promise.Invocable<Session> promise) {
        this.terminate();
        this.disconnect(error, reason, promise);
    }

    private void disconnect(long error, String reason, Promise.Invocable<Session> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("disconnecting 0x{}/{} on {}", new Object[]{Long.toHexString(error), reason, this});
        }
        Promise.Invocable p = Promise.Invocable.toPromise(promise, ps -> this);
        this.getProtocolSession().disconnect(new ConnectionCloseFrame(error, reason), null, Promise.Invocable.from((Promise.Invocable)p, () -> this.notifyDisconnect(error, reason)));
    }

    private void failStreams(Predicate<HTTP3Stream> predicate, long error, Throwable failure) {
        this.streams.values().stream().filter(predicate).forEach(stream -> stream.onFailure(error, failure));
    }

    private void terminate() {
        CompletableFuture<Session> shutdown;
        if (LOG.isDebugEnabled()) {
            LOG.debug("terminating {}", (Object)this);
        }
        this.streamTimeouts.destroy();
        try (AutoLock ignored = this.lock.lock();){
            shutdown = this.shutdown;
        }
        if (shutdown != null) {
            shutdown.complete(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void tryRunZeroStreamsAction() {
        action = null;
        ignored = this.lock.lock();
        try {
            count = this.streamCount.get();
            if (count > 0L) {
                if (HTTP3Session.LOG.isDebugEnabled()) {
                    HTTP3Session.LOG.debug("deferring closing action, {} pending streams on {}", (Object)count, (Object)this);
                }
                return;
            }
            switch (this.closeState.ordinal()) {
                case 1: {
                    if (this.goAwaySent.isGraceful()) {
                        action = this.zeroStreamsAction;
                        this.zeroStreamsAction = null;
                        ** break;
                    }
lbl15:
                    // 3 sources

                    break;
                }
                case 2: {
                    if (this.goAwaySent != null && this.goAwaySent.isGraceful()) {
                        action = this.zeroStreamsAction;
                        this.zeroStreamsAction = null;
                        ** break;
                    }
lbl21:
                    // 3 sources

                    break;
                }
                case 3: {
                    this.closeState = CloseState.CLOSED;
                    action = this.zeroStreamsAction;
                    this.zeroStreamsAction = null;
                    ** break;
lbl27:
                    // 1 sources

                    break;
                }
                case 0: 
                case 4: {
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        if (action != null) {
            if (HTTP3Session.LOG.isDebugEnabled()) {
                HTTP3Session.LOG.debug("executing zero streams action on {}", (Object)this);
            }
            action.run();
        }
    }

    public void onClose(long error, String reason) {
        boolean notifyFailure;
        if (LOG.isDebugEnabled()) {
            LOG.debug("session closed remotely 0x{}/{} {}", new Object[]{Long.toHexString(error), reason, this});
        }
        try (AutoLock ignored = this.lock.lock();){
            notifyFailure = this.closeState == CloseState.NOT_CLOSED;
            this.closeState = CloseState.CLOSED;
            this.zeroStreamsAction = null;
        }
        EofException failure = new EofException(reason);
        this.failStreams(stream -> true, error, (Throwable)failure);
        if (notifyFailure) {
            this.onSessionFailure(error, reason, (Throwable)failure);
        }
        this.disconnect(error, reason, (Promise.Invocable<Session>)Promise.Invocable.noop());
    }

    private void notifyDisconnect(long error, String reason) {
        try {
            this.listener.onDisconnect(this, error, reason);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    private void notifyFailure(long error, String reason, Throwable failure) {
        try {
            this.listener.onFailure(this, error, reason, failure);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)this.listener, (Object)x);
        }
    }

    public boolean isClosed() {
        return this.closeState == CloseState.CLOSED;
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{new DumpableCollection("streams", this.getStreams())});
    }

    public String toString() {
        return String.format("%s@%x[streams=%d,%s]", new Object[]{TypeUtil.toShortName(this.getClass()), this.hashCode(), this.streamCount.get(), this.closeState});
    }

    private /* synthetic */ void lambda$close$11(long error, String reason, Promise.Invocable promise) {
        this.terminateAndDisconnect(error, reason, (Promise.Invocable<Session>)promise);
    }

    private static /* synthetic */ boolean lambda$close$10(HTTP3Stream stream) {
        return true;
    }

    private static /* synthetic */ boolean lambda$onGoAway$9(GoAwayFrame frame, HTTP3Stream stream) {
        return stream.isLocal() && stream.getId() > frame.getLastId();
    }

    private /* synthetic */ void lambda$onGoAway$8(GoAwayFrame goAwayFrame) {
        this.writeControlFrame(goAwayFrame, Callback.from(this::terminate));
    }

    private /* synthetic */ void lambda$onGoAway$7() {
        this.terminateAndDisconnect(HTTP3ErrorCode.NO_ERROR.code(), "go_away", (Promise.Invocable<Session>)Promise.Invocable.noop());
    }

    private /* synthetic */ void lambda$onGoAway$6(GoAwayFrame goAwayFrame) {
        this.writeControlFrame(goAwayFrame, Callback.from(() -> this.terminateAndDisconnect(HTTP3ErrorCode.NO_ERROR.code(), "go_away", (Promise.Invocable<Session>)Promise.Invocable.noop())));
    }

    private /* synthetic */ void lambda$onGoAway$4(GoAwayFrame goAwayFrame) {
        this.writeControlFrame(goAwayFrame, Callback.from(this::terminate));
    }

    private static /* synthetic */ boolean lambda$goAway$2(HTTP3Stream stream) {
        return true;
    }

    private /* synthetic */ void lambda$goAway$1() {
        this.goAway(false, (Promise.Invocable<Session>)Promise.Invocable.noop());
    }

    private /* synthetic */ void lambda$goAway$0() {
        this.goAway(false, (Promise.Invocable<Session>)Promise.Invocable.noop());
    }

    private static enum CloseState {
        NOT_CLOSED,
        LOCALLY_CLOSED,
        REMOTELY_CLOSED,
        CLOSING,
        CLOSED;

    }

    private class StreamTimeouts
    extends CyclicTimeouts<HTTP3Stream> {
        private StreamTimeouts(Scheduler scheduler) {
            super(scheduler);
        }

        protected Iterator<HTTP3Stream> iterator() {
            return HTTP3Session.this.streams.values().stream().filter(stream -> stream.getIdleTimeout() > 0L).iterator();
        }

        protected boolean onExpired(HTTP3Stream stream) {
            TimeoutException timeout = new TimeoutException("idle timeout " + stream.getIdleTimeout() + " ms elapsed");
            stream.onIdleTimeout(timeout, (Promise<Boolean>)Promise.from(timedOut -> {
                if (timedOut.booleanValue()) {
                    this.disconnect(stream, timeout);
                }
            }, x -> this.disconnect(stream, (Throwable)x)));
            return false;
        }

        private void disconnect(HTTP3Stream stream, Throwable failure) {
            stream.disconnect(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), failure, (Promise.Invocable<Stream>)Promise.Invocable.noop());
        }
    }

    private class FrameListener
    implements ParserListener {
        private FrameListener() {
        }

        @Override
        public void onHeaders(long streamId, HeadersFrame frame, boolean wasBlocked) {
            HTTP3Session.this.onHeaders(streamId, frame, wasBlocked);
        }

        @Override
        public void onData(long streamId, DataFrame frame) {
            HTTP3Session.this.onData(streamId, frame);
        }

        @Override
        public void onSettings(SettingsFrame frame) {
            HTTP3Session.this.onSettings(frame);
        }

        @Override
        public void onGoAway(GoAwayFrame frame) {
            HTTP3Session.this.onGoAway(frame);
        }

        @Override
        public void onStreamFailure(long streamId, long error, Throwable failure) {
            HTTP3Session.this.onStreamFailure(streamId, error, failure);
        }

        @Override
        public void onSessionFailure(long error, String reason, Throwable failure) {
            HTTP3Session.this.onSessionFailure(error, reason, failure);
        }
    }
}

