/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.generator;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.FrameType;
import org.eclipse.jetty.http3.frames.GoAwayFrame;
import org.eclipse.jetty.http3.generator.FrameGenerator;
import org.eclipse.jetty.http3.internal.VarLenInt;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class GoAwayGenerator
extends FrameGenerator {
    private final boolean useDirectByteBuffers;

    public GoAwayGenerator(ByteBufferPool bufferPool, boolean useDirectByteBuffers) {
        super(bufferPool);
        this.useDirectByteBuffers = useDirectByteBuffers;
    }

    @Override
    public int generate(ByteBufferPool.Accumulator accumulator, long streamId, Frame frame, Consumer<Throwable> fail) {
        GoAwayFrame goAwayFrame = (GoAwayFrame)frame;
        return this.generateGoAwayFrame(accumulator, goAwayFrame);
    }

    private int generateGoAwayFrame(ByteBufferPool.Accumulator accumulator, GoAwayFrame frame) {
        long lastId = frame.getLastId();
        int lastIdLength = VarLenInt.length(lastId);
        int length = VarLenInt.length(FrameType.GOAWAY.type()) + VarLenInt.length(lastIdLength) + lastIdLength;
        RetainableByteBuffer.Mutable buffer = this.getByteBufferPool().acquire(length, this.useDirectByteBuffers);
        ByteBuffer byteBuffer = buffer.getByteBuffer();
        BufferUtil.clearToFill((ByteBuffer)byteBuffer);
        VarLenInt.encode(byteBuffer, FrameType.GOAWAY.type());
        VarLenInt.encode(byteBuffer, lastIdLength);
        VarLenInt.encode(byteBuffer, lastId);
        byteBuffer.flip();
        accumulator.append((RetainableByteBuffer)buffer);
        return length;
    }
}

