/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.HTTP3Stream;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.parser.MessageParser;
import org.eclipse.jetty.http3.parser.ParserListener;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTP3StreamConnection
extends AbstractConnection {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3StreamConnection.class);
    private static final ByteBuffer EMPTY_DATA_FRAME = ByteBuffer.allocate(2);
    private final AtomicReference<Runnable> action = new AtomicReference();
    private final ByteBufferPool bufferPool;
    private final int minInputBufferSpace;
    private final MessageParser parser;
    private boolean useInputDirectByteBuffers = true;
    private HTTP3Stream stream;
    private RetainableByteBuffer inputBuffer;
    private boolean remotelyClosed;

    public HTTP3StreamConnection(QuicStreamEndPoint endPoint, Executor executor, ByteBufferPool bufferPool, MessageParser parser) {
        this(endPoint, executor, bufferPool, parser, -1);
    }

    public HTTP3StreamConnection(QuicStreamEndPoint endPoint, Executor executor, ByteBufferPool bufferPool, MessageParser parser, int minInputBufferSpace) {
        super((EndPoint)endPoint, executor);
        this.bufferPool = bufferPool;
        this.parser = parser;
        parser.init(x$0 -> new MessageListener((ParserListener)x$0));
        this.minInputBufferSpace = minInputBufferSpace < 0 ? 1500 : minInputBufferSpace;
    }

    public void onFailure(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFailure on {}", (Object)this, (Object)failure);
        }
        this.tryReleaseInputBuffer(true);
    }

    public QuicStreamEndPoint getEndPoint() {
        return (QuicStreamEndPoint)super.getEndPoint();
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    void setStream(HTTP3Stream stream) {
        this.stream = stream;
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public void onClose(Throwable cause) {
        super.onClose(cause);
        this.tryReleaseInputBuffer(true);
    }

    protected boolean onReadTimeout(TimeoutException timeout) {
        return false;
    }

    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFillable dataMode={} on {}", (Object)this.parser.isDataMode(), (Object)this);
        }
        if (this.parser.isDataMode()) {
            this.processDataFrames(true);
        } else {
            this.processNonDataFrames();
        }
    }

    private void processDataFrames(boolean setFillInterest) {
        try {
            this.tryAcquireInputBuffer();
            MessageParser.Result result = this.parseAndFill(setFillInterest);
            switch (result) {
                case NO_FRAME: {
                    this.tryReleaseInputBuffer(false);
                    break;
                }
                case SWITCH_MODE: {
                    this.parser.setDataMode(false);
                    this.processNonDataFrames();
                    break;
                }
                case FRAME: {
                    ((Runnable)this.action.getAndSet(null)).run();
                    if (!this.remotelyClosed) break;
                    this.getEndPoint().getQuicSession().flush();
                    this.tryReleaseInputBuffer(false);
                }
            }
        }
        catch (Throwable x) {
            this.tryReleaseInputBuffer(true);
            long error = HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code();
            this.getEndPoint().close(error, x);
            this.parser.getListener().onStreamFailure(this.getEndPoint().getStreamId(), error, x);
        }
    }

    private void processNonDataFrames() {
        try {
            MessageParser.Result result;
            this.tryAcquireInputBuffer();
            block8: while (true) {
                result = this.parseAndFill(true);
                switch (result) {
                    case NO_FRAME: {
                        this.tryReleaseInputBuffer(false);
                        return;
                    }
                    case BLOCKED_FRAME: {
                        this.tryReleaseInputBuffer(false);
                        return;
                    }
                    case SWITCH_MODE: {
                        throw new IllegalStateException();
                    }
                    case FRAME: {
                        Runnable action = this.action.getAndSet(null);
                        if (action == null) {
                            throw new IllegalStateException();
                        }
                        action.run();
                        if (!this.remotelyClosed) continue block8;
                        this.getEndPoint().getQuicSession().flush();
                        this.tryReleaseInputBuffer(false);
                        return;
                        if (!this.parser.isDataMode()) continue block8;
                        if (this.stream.hasDemandOrStall()) {
                            if (this.inputBuffer != null && this.inputBuffer.hasRemaining()) {
                                this.processDataFrames(true);
                            } else {
                                this.tryReleaseInputBuffer(false);
                                this.fillInterested();
                            }
                        }
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("unknown message parser result: " + String.valueOf((Object)result));
        }
        catch (Throwable x) {
            this.tryReleaseInputBuffer(true);
            long error = HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code();
            this.getEndPoint().close(error, x);
            this.parser.getListener().onStreamFailure(this.getEndPoint().getStreamId(), error, x);
            return;
        }
    }

    public void receive() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("receiving on {}", (Object)this);
        }
        this.processDataFrames(false);
    }

    private void tryAcquireInputBuffer() {
        if (this.inputBuffer == null) {
            this.inputBuffer = this.bufferPool.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
            if (LOG.isDebugEnabled()) {
                LOG.debug("acquired {}", (Object)this.inputBuffer);
            }
        }
    }

    private void tryReleaseInputBuffer(boolean force) {
        if (this.inputBuffer != null) {
            if (this.inputBuffer.isRetained() && !force) {
                return;
            }
            if (this.inputBuffer.hasRemaining() && force) {
                this.inputBuffer.clear();
            }
            if (this.inputBuffer.isEmpty()) {
                this.inputBuffer.release();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("released {}", (Object)this.inputBuffer);
                }
                this.inputBuffer = null;
            }
        }
    }

    private MessageParser.Result parseAndFill(boolean setFillInterest) throws IOException {
        try {
            int filled;
            if (LOG.isDebugEnabled()) {
                LOG.debug("parse+fill setFillInterest={} on {} with buffer {}", new Object[]{setFillInterest, this, this.inputBuffer});
            }
            do {
                ByteBuffer byteBuffer = this.inputBuffer.getByteBuffer();
                MessageParser.Result result = this.parser.parse(byteBuffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("parsed {} on {} with buffer {}", new Object[]{result, this, this.inputBuffer});
                }
                if (result != MessageParser.Result.NO_FRAME) {
                    return result;
                }
                boolean compact = true;
                if (this.inputBuffer.isRetained()) {
                    if (this.minInputBufferSpace > 0 && BufferUtil.space((ByteBuffer)this.inputBuffer.getByteBuffer()) >= this.minInputBufferSpace) {
                        compact = false;
                    } else {
                        this.inputBuffer.release();
                        RetainableByteBuffer.Mutable newBuffer = this.bufferPool.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("reacquired {} for retained {}", (Object)newBuffer, (Object)this.inputBuffer);
                        }
                        this.inputBuffer = newBuffer;
                        byteBuffer = this.inputBuffer.getByteBuffer();
                    }
                }
                filled = this.fill(byteBuffer, compact);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("filled {} on {} with buffer {}", new Object[]{filled, this, this.inputBuffer});
            } while (filled > 0);
            if (filled == 0) {
                if (!this.remotelyClosed && this.getEndPoint().isStreamFinished()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("detected end of stream on {}", (Object)this);
                    }
                    this.parser.parse(EMPTY_DATA_FRAME.slice());
                    return MessageParser.Result.FRAME;
                }
                if (setFillInterest) {
                    this.fillInterested();
                }
            }
            return MessageParser.Result.NO_FRAME;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("parse+fill failure on {}", (Object)this, (Object)x);
            }
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fill(ByteBuffer buffer, boolean compact) throws IOException {
        int padding = 0;
        try {
            if (!compact) {
                padding = buffer.limit();
                buffer.position(0);
            }
            int n = this.getEndPoint().fill(buffer);
            return n;
        }
        finally {
            if (!compact && padding > 0) {
                buffer.position(padding);
            }
        }
    }

    private void processHeaders(HeadersFrame frame, boolean wasBlocked, Runnable delegate) {
        MetaData metaData = frame.getMetaData();
        if (metaData.isRequest()) {
            this.parser.setDataMode(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("switching to dataMode=true for request {} on {}", (Object)metaData, (Object)this);
            }
        } else if (metaData.isResponse()) {
            MetaData.Response response = (MetaData.Response)metaData;
            if (HttpStatus.isInformational((int)response.getStatus())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("staying in dataMode=false for response {} on {}", (Object)metaData, (Object)this);
                }
            } else {
                this.parser.setDataMode(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("switching to dataMode=true for response {} on {}", (Object)metaData, (Object)this);
                }
            }
        } else if (!frame.isLast()) {
            frame = new HeadersFrame(metaData, true);
        }
        if (frame.isLast()) {
            this.shutdownInput();
        }
        delegate.run();
        if (wasBlocked) {
            this.onFillable();
        }
    }

    private void processData(DataFrame frame, Runnable delegate) {
        if (frame.isLast()) {
            this.shutdownInput();
        }
        Stream.Data data = !frame.getByteBuffer().hasRemaining() && frame.isLast() ? Stream.Data.EOF : new StreamData(frame, this.inputBuffer);
        delegate.run();
        if (LOG.isDebugEnabled()) {
            LOG.debug("notifying {} on {}", (Object)data, (Object)this.stream);
        }
        this.stream.onData(data);
    }

    private void shutdownInput() {
        this.remotelyClosed = true;
        this.getEndPoint().shutdownInput(HTTP3ErrorCode.NO_ERROR.code());
    }

    public String toConnectionString() {
        return String.format("%s[dataMode=%b,stream=%s]", super.toConnectionString(), this.parser.isDataMode(), this.stream);
    }

    private static class StreamData
    extends Stream.Data {
        private final RetainableByteBuffer retainable;

        public StreamData(DataFrame frame, RetainableByteBuffer retainable) {
            super(frame);
            this.retainable = retainable;
        }

        public boolean canRetain() {
            return this.retainable.canRetain();
        }

        public boolean isRetained() {
            return this.retainable.isRetained();
        }

        public void retain() {
            this.retainable.retain();
        }

        public boolean release() {
            return this.retainable.release();
        }
    }

    private class MessageListener
    extends ParserListener.Wrapper {
        private MessageListener(ParserListener listener) {
            super(listener);
        }

        @Override
        public void onHeaders(long streamId, HeadersFrame frame, boolean wasBlocked) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("received {}#{} wasBlocked={}", new Object[]{frame, streamId, wasBlocked});
            }
            Runnable delegate = () -> super.onHeaders(streamId, frame, wasBlocked);
            Runnable action = () -> HTTP3StreamConnection.this.processHeaders(frame, wasBlocked, delegate);
            if (wasBlocked) {
                action.run();
            } else if (!HTTP3StreamConnection.this.action.compareAndSet(null, action)) {
                throw new IllegalStateException();
            }
        }

        @Override
        public void onData(long streamId, DataFrame frame) {
            Runnable delegate;
            Runnable action;
            if (LOG.isDebugEnabled()) {
                LOG.debug("received {}#{}", (Object)frame, (Object)streamId);
            }
            if (!HTTP3StreamConnection.this.action.compareAndSet(null, action = () -> this.lambda$onData$3(frame, delegate = () -> super.onData(streamId, frame)))) {
                throw new IllegalStateException();
            }
        }

        private /* synthetic */ void lambda$onData$3(DataFrame frame, Runnable delegate) {
            HTTP3StreamConnection.this.processData(frame, delegate);
        }
    }
}

