/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.generator;

import java.util.function.Consumer;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.FrameType;
import org.eclipse.jetty.http3.generator.DataGenerator;
import org.eclipse.jetty.http3.generator.FrameGenerator;
import org.eclipse.jetty.http3.generator.HeadersGenerator;
import org.eclipse.jetty.http3.generator.PushPromiseGenerator;
import org.eclipse.jetty.http3.qpack.QpackEncoder;
import org.eclipse.jetty.io.ByteBufferPool;

public class MessageGenerator {
    private final FrameGenerator[] generators = new FrameGenerator[FrameType.maxType() + 1];

    public MessageGenerator(ByteBufferPool bufferPool, QpackEncoder encoder, boolean useDirectByteBuffers) {
        this.generators[FrameType.DATA.type()] = new DataGenerator(bufferPool, useDirectByteBuffers);
        this.generators[FrameType.HEADERS.type()] = new HeadersGenerator(bufferPool, encoder, useDirectByteBuffers);
        this.generators[FrameType.PUSH_PROMISE.type()] = new PushPromiseGenerator(bufferPool);
    }

    public int generate(ByteBufferPool.Accumulator accumulator, long streamId, Frame frame, Consumer<Throwable> fail) {
        return this.generators[frame.getFrameType().type()].generate(accumulator, streamId, frame, fail);
    }
}

