/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal;

import java.util.List;
import org.eclipse.jetty.http3.internal.InstructionFlusher;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstructionHandler
implements Instruction.Handler {
    private static final Logger LOG = LoggerFactory.getLogger(InstructionHandler.class);
    private final InstructionFlusher encoderFlusher;

    public InstructionHandler(InstructionFlusher encoderFlusher) {
        this.encoderFlusher = encoderFlusher;
    }

    public void onInstructions(List<Instruction> instructions) {
        if (this.encoderFlusher.offer(instructions)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("processing {}", instructions);
            }
            this.encoderFlusher.iterate();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("could not process {}", instructions);
        }
    }
}

