/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal.parser;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.internal.HTTP3ErrorCode;
import org.eclipse.jetty.http3.internal.parser.BodyParser;
import org.eclipse.jetty.http3.internal.parser.HeaderParser;
import org.eclipse.jetty.http3.internal.parser.ParserListener;
import org.eclipse.jetty.http3.qpack.QpackDecoder;
import org.eclipse.jetty.http3.qpack.QpackException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadersBodyParser
extends BodyParser {
    private static final Logger LOG = LoggerFactory.getLogger(HeadersBodyParser.class);
    private final List<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>();
    private final long streamId;
    private final BooleanSupplier isLast;
    private final QpackDecoder decoder;
    private State state = State.INIT;
    private long length;

    public HeadersBodyParser(HeaderParser headerParser, ParserListener listener, QpackDecoder decoder, long streamId, BooleanSupplier isLast) {
        super(headerParser, listener);
        this.streamId = streamId;
        this.isLast = isLast;
        this.decoder = decoder;
    }

    private void reset() {
        this.state = State.INIT;
        this.length = 0L;
    }

    @Override
    public BodyParser.Result parse(ByteBuffer buffer) {
        block4: while (buffer.hasRemaining()) {
            switch (this.state) {
                case INIT: {
                    this.length = this.getBodyLength();
                    this.state = State.HEADERS;
                    continue block4;
                }
                case HEADERS: {
                    ByteBuffer encoded;
                    int remaining = buffer.remaining();
                    if ((long)remaining < this.length) {
                        this.length -= (long)remaining;
                        ByteBuffer copy = buffer.isDirect() ? ByteBuffer.allocateDirect(remaining) : ByteBuffer.allocate(remaining);
                        copy.put(buffer);
                        copy.flip();
                        this.byteBuffers.add(copy);
                        return BodyParser.Result.NO_FRAME;
                    }
                    int position = buffer.position();
                    int limit = buffer.limit();
                    int newPosition = position + (int)this.length;
                    buffer.limit(newPosition);
                    ByteBuffer slice = buffer.slice();
                    buffer.limit(limit);
                    buffer.position(newPosition);
                    if (this.byteBuffers.isEmpty()) {
                        encoded = slice;
                    } else {
                        this.byteBuffers.add(slice);
                        int capacity = this.byteBuffers.stream().mapToInt(Buffer::remaining).sum();
                        encoded = this.byteBuffers.stream().reduce(ByteBuffer.allocate(capacity), ByteBuffer::put);
                        encoded.flip();
                        this.byteBuffers.clear();
                    }
                    boolean last = this.isLast.getAsBoolean() && !buffer.hasRemaining();
                    return this.decode(encoded, last) ? BodyParser.Result.WHOLE_FRAME : BodyParser.Result.BLOCKED_FRAME;
                }
            }
            throw new IllegalStateException();
        }
        return BodyParser.Result.NO_FRAME;
    }

    private boolean decode(ByteBuffer encoded, boolean last) {
        try {
            return this.decoder.decode(this.streamId, encoded, (streamId, metaData, wasBlocked) -> this.onHeaders(metaData, last, wasBlocked));
        }
        catch (QpackException.StreamException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("decode failure", (Throwable)x);
            }
            this.notifyStreamFailure(this.streamId, x.getErrorCode(), x);
        }
        catch (QpackException.SessionException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("decode failure", (Throwable)x);
            }
            this.notifySessionFailure(x.getErrorCode(), x.getMessage(), x);
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("decode failure", x);
            }
            this.notifySessionFailure(HTTP3ErrorCode.INTERNAL_ERROR.code(), "internal_error", x);
        }
        return false;
    }

    private void onHeaders(MetaData metaData, boolean last, boolean wasBlocked) {
        HeadersFrame frame = new HeadersFrame(metaData, last);
        this.reset();
        this.notifyHeaders(frame, wasBlocked);
    }

    protected void notifyHeaders(HeadersFrame frame, boolean wasBlocked) {
        ParserListener listener = this.getParserListener();
        try {
            listener.onHeaders(this.streamId, frame, wasBlocked);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    private static enum State {
        INIT,
        HEADERS;

    }
}

