/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client;

import java.util.Map;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.client.HTTP3Client;
import org.eclipse.jetty.http3.client.internal.ClientHTTP3Session;
import org.eclipse.jetty.http3.client.internal.ClientHTTP3StreamConnection;
import org.eclipse.jetty.http3.internal.parser.MessageParser;
import org.eclipse.jetty.http3.internal.parser.ParserListener;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.client.ClientQuicSession;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3ClientConnectionFactory
implements ClientConnectionFactory,
ProtocolSession.Factory {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3ClientConnectionFactory.class);

    public ProtocolSession newProtocolSession(QuicSession quicSession, Map<String, Object> context) {
        HTTP3Client client = (HTTP3Client)((Object)context.get(HTTP3Client.CLIENT_CONTEXT_KEY));
        Session.Client.Listener listener = (Session.Client.Listener)context.get(HTTP3Client.SESSION_LISTENER_CONTEXT_KEY);
        Promise promise = (Promise)context.get(HTTP3Client.SESSION_PROMISE_CONTEXT_KEY);
        ClientHTTP3Session session = new ClientHTTP3Session(client.getHTTP3Configuration(), (ClientQuicSession)quicSession, listener, (Promise<Session.Client>)promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("created protocol-specific {}", (Object)session);
        }
        return session;
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        QuicStreamEndPoint streamEndPoint = (QuicStreamEndPoint)endPoint;
        long streamId = streamEndPoint.getStreamId();
        ClientHTTP3Session http3Session = (ClientHTTP3Session)streamEndPoint.getQuicSession().getProtocolSession();
        MessageParser parser = new MessageParser((ParserListener)http3Session.getSessionClient(), http3Session.getQpackDecoder(), streamId, () -> ((QuicStreamEndPoint)streamEndPoint).isStreamFinished());
        ClientHTTP3StreamConnection connection = new ClientHTTP3StreamConnection(streamEndPoint, http3Session, parser);
        return this.customize((Connection)connection, context);
    }
}

