/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpTransportOverHTTP2
implements HttpTransport {
    private static final Logger LOG = Log.getLogger(HttpTransportOverHTTP2.class);
    private final AtomicBoolean commit = new AtomicBoolean();
    private final TransportCallback transportCallback = new TransportCallback();
    private final Connector connector;
    private final HTTP2ServerConnection connection;
    private IStream stream;

    public HttpTransportOverHTTP2(Connector connector, HTTP2ServerConnection connection) {
        this.connector = connector;
        this.connection = connection;
    }

    public boolean isOptimizedForDirectBuffers() {
        return this.connection.getEndPoint().isOptimizedForDirectBuffers();
    }

    public IStream getStream() {
        return this.stream;
    }

    public void setStream(IStream stream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} setStream {}", new Object[]{this, stream.getId()});
        }
        this.stream = stream;
    }

    public void recycle() {
        this.stream = null;
        this.commit.set(false);
    }

    public void send(MetaData.Response info, boolean isHeadRequest, final ByteBuffer content, final boolean lastContent, final Callback callback) {
        boolean hasContent;
        boolean bl = hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        if (info != null) {
            int status = info.getStatus();
            boolean informational = HttpStatus.isInformational((int)status) && status != 101;
            boolean committed = false;
            if (!informational) {
                committed = this.commit.compareAndSet(false, true);
            }
            if (committed || informational) {
                if (hasContent) {
                    Callback.Nested commitCallback = new Callback.Nested(callback){

                        public void succeeded() {
                            if (HttpTransportOverHTTP2.this.transportCallback.start(callback, false)) {
                                HttpTransportOverHTTP2.this.send(content, lastContent, HttpTransportOverHTTP2.this.transportCallback);
                            }
                        }
                    };
                    if (this.transportCallback.start((Callback)commitCallback, true)) {
                        this.commit(info, false, this.transportCallback);
                    }
                } else if (this.transportCallback.start(callback, false)) {
                    this.commit(info, lastContent, this.transportCallback);
                }
            } else {
                callback.failed((Throwable)new IllegalStateException("committed"));
            }
        } else if (hasContent || lastContent) {
            if (this.transportCallback.start(callback, false)) {
                this.send(content, lastContent, this.transportCallback);
            }
        } else {
            callback.succeeded();
        }
    }

    public boolean isPushSupported() {
        return this.stream.getSession().isPushEnabled();
    }

    public void push(final MetaData.Request request) {
        if (!this.stream.getSession().isPushEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/2 Push disabled for {}", new Object[]{request});
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP/2 Push {}", new Object[]{request});
        }
        this.stream.push(new PushPromiseFrame(this.stream.getId(), 0, (MetaData)request), (Promise)new Promise<Stream>(){

            public void succeeded(Stream pushStream) {
                HttpTransportOverHTTP2.this.connection.push(HttpTransportOverHTTP2.this.connector, (IStream)pushStream, request);
            }

            public void failed(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not push " + request, x);
                }
            }
        }, (Stream.Listener)new Stream.Listener.Adapter());
    }

    private void commit(MetaData.Response info, boolean endStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}:{}{} {}{}{}", new Object[]{this.stream.getId(), System.lineSeparator(), HttpVersion.HTTP_2, info.getStatus(), System.lineSeparator(), info.getFields()});
        }
        HeadersFrame frame = new HeadersFrame(this.stream.getId(), (MetaData)info, null, endStream);
        this.stream.headers(frame, callback);
    }

    private void send(ByteBuffer content, boolean lastContent, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}: {} content bytes{}", new Object[]{this.stream.getId(), content.remaining(), lastContent ? " (last chunk)" : ""});
        }
        DataFrame frame = new DataFrame(this.stream.getId(), content, lastContent);
        this.stream.data(frame, callback);
    }

    public boolean onStreamTimeout(Throwable failure) {
        return this.transportCallback.onIdleTimeout(failure);
    }

    public void onCompleted() {
        HttpChannelOverHTTP2 channel;
        if (!this.stream.isClosed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{}: unconsumed request content, resetting stream", (long)this.stream.getId());
            }
            this.stream.reset(new ResetFrame(this.stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
        }
        if ((channel = (HttpChannelOverHTTP2)((Object)this.stream.getAttribute(IStream.CHANNEL_ATTRIBUTE))) != null) {
            channel.consumeInput();
        }
    }

    public void abort(Throwable failure) {
        IStream stream = this.stream;
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{} aborted", stream == null ? -1L : (long)stream.getId());
        }
        if (stream != null) {
            stream.reset(new ResetFrame(stream.getId(), ErrorCode.INTERNAL_ERROR.code), Callback.NOOP);
        }
    }

    private static enum State {
        IDLE,
        WRITING,
        FAILED,
        TIMEOUT;

    }

    private class TransportCallback
    implements Callback {
        private State state = State.IDLE;
        private Callback callback;
        private boolean commit;

        private TransportCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean start(Callback callback, boolean commit) {
            State state;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                state = this.state;
                if (state == State.IDLE) {
                    this.state = State.WRITING;
                    this.callback = callback;
                    this.commit = commit;
                    return true;
                }
            }
            callback.failed((Throwable)new IllegalStateException("Invalid transport state: " + (Object)((Object)state)));
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void succeeded() {
            boolean commit;
            Callback callback = null;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                commit = this.commit;
                if (this.state != State.TIMEOUT) {
                    callback = this.callback;
                    this.state = State.IDLE;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{} {}", new Object[]{HttpTransportOverHTTP2.this.stream.getId(), commit ? "committed" : "flushed content"});
            }
            if (callback != null) {
                callback.succeeded();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Throwable x) {
            boolean commit;
            Callback callback = null;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                commit = this.commit;
                if (this.state != State.TIMEOUT) {
                    callback = this.callback;
                    this.state = State.FAILED;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #" + HttpTransportOverHTTP2.this.stream.getId() + " failed to " + (commit ? "commit" : "flush"), x);
            }
            if (callback != null) {
                callback.failed(x);
            }
        }

        public boolean isNonBlocking() {
            return this.callback.isNonBlocking();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onIdleTimeout(Throwable failure) {
            boolean result;
            Callback callback = null;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                boolean bl = result = this.state == State.WRITING;
                if (result) {
                    callback = this.callback;
                    this.state = State.TIMEOUT;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #" + HttpTransportOverHTTP2.this.stream.getId() + " idle timeout", failure);
            }
            if (result) {
                callback.failed(failure);
            }
            return result;
        }
    }
}

