/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.server.HttpTransportOverHTTP2;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpChannelOverHTTP2
extends HttpChannel {
    private static final Logger LOG = Log.getLogger(HttpChannelOverHTTP2.class);
    private static final HttpField SERVER_VERSION = new PreEncodedHttpField(HttpHeader.SERVER, HttpConfiguration.SERVER_VERSION);
    private static final HttpField POWERED_BY = new PreEncodedHttpField(HttpHeader.X_POWERED_BY, HttpConfiguration.SERVER_VERSION);
    private boolean _expect100Continue = false;

    public HttpChannelOverHTTP2(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransportOverHTTP2 transport) {
        super(connector, configuration, endPoint, (HttpTransport)transport);
    }

    private IStream getStream() {
        return this.getHttpTransport().getStream();
    }

    public boolean isExpecting100Continue() {
        return this._expect100Continue;
    }

    public Runnable onRequest(HeadersFrame frame) {
        MetaData.Request request = (MetaData.Request)frame.getMetaData();
        HttpFields fields = request.getFields();
        this._expect100Continue = fields.contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
        HttpFields response = this.getResponse().getHttpFields();
        if (this.getHttpConfiguration().getSendServerVersion()) {
            response.add(SERVER_VERSION);
        }
        if (this.getHttpConfiguration().getSendXPoweredBy()) {
            response.add(POWERED_BY);
        }
        this.onRequest(request);
        if (frame.isEndStream()) {
            this.onRequestComplete();
        }
        if (LOG.isDebugEnabled()) {
            IStream stream = this.getStream();
            LOG.debug("HTTP2 Request #{}/{}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), request.getMethod(), request.getURI(), request.getVersion(), System.lineSeparator(), fields});
        }
        return this;
    }

    public Runnable onPushRequest(MetaData.Request request) {
        this.onRequest(request);
        this.getRequest().setAttribute("org.eclipse.jetty.pushed", (Object)Boolean.TRUE);
        this.onRequestComplete();
        if (LOG.isDebugEnabled()) {
            IStream stream = this.getStream();
            LOG.debug("HTTP2 PUSH Request #{}/{}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), request.getMethod(), request.getURI(), request.getVersion(), System.lineSeparator(), request.getFields()});
        }
        return this;
    }

    public HttpTransportOverHTTP2 getHttpTransport() {
        return (HttpTransportOverHTTP2)super.getHttpTransport();
    }

    public void recycle() {
        super.recycle();
        this.getHttpTransport().recycle();
    }

    protected void commit(MetaData.Response info) {
        super.commit(info);
        if (LOG.isDebugEnabled()) {
            IStream stream = this.getStream();
            LOG.debug("HTTP2 Commit Response #{}/{}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), info.getVersion(), info.getStatus(), info.getReason(), System.lineSeparator(), info.getFields()});
        }
    }

    public void requestContent(DataFrame frame, final Callback callback) {
        final ByteBufferPool byteBufferPool = this.getByteBufferPool();
        ByteBuffer original = frame.getData();
        final ByteBuffer copy = byteBufferPool.acquire(original.remaining(), original.isDirect());
        BufferUtil.clearToFill((ByteBuffer)copy);
        copy.put(original).flip();
        if (LOG.isDebugEnabled()) {
            IStream stream = this.getStream();
            LOG.debug("HTTP2 Request #{}/{}: {} bytes of content", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), copy.remaining()});
        }
        this.onContent(new HttpInput.Content(copy){

            public void succeeded() {
                byteBufferPool.release(copy);
                callback.succeeded();
            }

            public void failed(Throwable x) {
                byteBufferPool.release(copy);
                callback.failed(x);
            }
        });
        if (frame.isEndStream()) {
            this.onRequestComplete();
        }
    }

    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this._expect100Continue = false;
            if (available == 0) {
                if (this.getResponse().isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                boolean committed = this.sendResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!committed) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }
}

