/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.parser.ServerParser;
import org.eclipse.jetty.http2.server.AbstractHTTP2ServerConnectionFactory;
import org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.server.HttpInputOverHTTP2;
import org.eclipse.jetty.http2.server.HttpTransportOverHTTP2;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HTTP2ServerConnectionFactory
extends AbstractHTTP2ServerConnectionFactory {
    private static final Logger LOG = Log.getLogger(HTTP2ServerConnectionFactory.class);
    private final HttpConfiguration httpConfiguration;

    public HTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }

    @Override
    protected ServerSessionListener newSessionListener(Connector connector, EndPoint endPoint) {
        return new HTTPServerSessionListener(connector, this.httpConfiguration, endPoint);
    }

    @Override
    protected ServerParser newServerParser(ByteBufferPool byteBufferPool, ServerParser.Listener listener) {
        return new ServerParser(byteBufferPool, listener, this.getMaxHeaderTableSize(), this.httpConfiguration.getRequestHeaderSize());
    }

    private class HTTPServerSessionListener
    extends ServerSessionListener.Adapter
    implements Stream.Listener {
        private final Connector connector;
        private final HttpConfiguration httpConfiguration;
        private final EndPoint endPoint;

        public HTTPServerSessionListener(Connector connector, HttpConfiguration httpConfiguration, EndPoint endPoint) {
            this.connector = connector;
            this.httpConfiguration = httpConfiguration;
            this.endPoint = endPoint;
        }

        public Map<Integer, Integer> onPreface(Session session) {
            HashMap<Integer, Integer> settings = new HashMap<Integer, Integer>();
            settings.put(1, HTTP2ServerConnectionFactory.this.getMaxHeaderTableSize());
            settings.put(4, HTTP2ServerConnectionFactory.this.getInitialStreamWindow());
            int maxConcurrentStreams = HTTP2ServerConnectionFactory.this.getMaxConcurrentStreams();
            if (maxConcurrentStreams >= 0) {
                settings.put(3, maxConcurrentStreams);
            }
            return settings;
        }

        public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing {} on {}", new Object[]{frame, stream});
            }
            MetaData.Request request = (MetaData.Request)frame.getMetaData();
            HttpTransportOverHTTP2 transport = new HttpTransportOverHTTP2(this.connector, this.httpConfiguration, this.endPoint, (IStream)stream, request);
            HttpInputOverHTTP2 input = new HttpInputOverHTTP2();
            HttpChannelOverHTTP2 channel = new HttpChannelOverHTTP2(this.connector, this.httpConfiguration, this.endPoint, transport, (HttpInput)input, stream);
            stream.setAttribute(IStream.CHANNEL_ATTRIBUTE, (Object)channel);
            channel.onRequest(frame);
            return frame.isEndStream() ? null : this;
        }

        public void onHeaders(Stream stream, HeadersFrame frame) {
            this.close(stream, "response_headers");
        }

        public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
            this.close(stream, "push_promise");
            return null;
        }

        public void onData(Stream stream, DataFrame frame, Callback callback) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing {} on {}", new Object[]{frame, stream});
            }
            HttpChannelOverHTTP2 channel = (HttpChannelOverHTTP2)((Object)stream.getAttribute(IStream.CHANNEL_ATTRIBUTE));
            channel.requestContent(frame, callback);
        }

        public void onFailure(Stream stream, Throwable x) {
        }

        private void close(Stream stream, String reason) {
            Session session = stream.getSession();
            session.close(1, reason, (Callback)Callback.Adapter.INSTANCE);
        }
    }
}

