/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.util.concurrent.Executor;
import org.eclipse.jetty.http2.FlowControl;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.HTTP2FlowControl;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.generator.Generator;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.http2.parser.ServerParser;
import org.eclipse.jetty.http2.server.HTTP2ServerSession;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;

public abstract class AbstractHTTP2ServerConnectionFactory
extends AbstractConnectionFactory {
    private int maxHeaderTableSize = 4096;
    private int initialStreamWindow = 65535;
    private int maxConcurrentStreams = -1;

    public AbstractHTTP2ServerConnectionFactory() {
        super("h2-14");
    }

    public int getMaxHeaderTableSize() {
        return this.maxHeaderTableSize;
    }

    public void setMaxHeaderTableSize(int maxHeaderTableSize) {
        this.maxHeaderTableSize = maxHeaderTableSize;
    }

    public int getInitialStreamWindow() {
        return this.initialStreamWindow;
    }

    public void setInitialStreamWindow(int initialStreamWindow) {
        this.initialStreamWindow = initialStreamWindow;
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public Connection newConnection(Connector connector, EndPoint endPoint) {
        ServerSessionListener listener = this.newSessionListener(connector, endPoint);
        Generator generator = new Generator(connector.getByteBufferPool(), this.getMaxHeaderTableSize());
        HTTP2ServerSession session = new HTTP2ServerSession(connector.getScheduler(), endPoint, generator, listener, (FlowControl)new HTTP2FlowControl(this.getInitialStreamWindow()));
        session.setMaxLocalStreams(this.getMaxConcurrentStreams());
        session.setMaxRemoteStreams(this.getMaxConcurrentStreams());
        long idleTimeout = endPoint.getIdleTimeout();
        if (idleTimeout > 0L) {
            idleTimeout /= 2L;
        }
        session.setStreamIdleTimeout(idleTimeout);
        ServerParser parser = this.newServerParser(connector.getByteBufferPool(), session);
        HTTP2ServerConnection connection = new HTTP2ServerConnection(connector.getByteBufferPool(), connector.getExecutor(), endPoint, (Parser)parser, (ISession)session, this.getInputBufferSize(), listener);
        return this.configure((AbstractConnection)connection, connector, endPoint);
    }

    protected abstract ServerSessionListener newSessionListener(Connector var1, EndPoint var2);

    protected abstract ServerParser newServerParser(ByteBufferPool var1, ServerParser.Listener var2);

    private class HTTP2ServerConnection
    extends HTTP2Connection {
        private final ServerSessionListener listener;

        public HTTP2ServerConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, Parser parser, ISession session, int inputBufferSize, ServerSessionListener listener) {
            super(byteBufferPool, executor, endPoint, parser, session, inputBufferSize);
            this.listener = listener;
        }

        public void onOpen() {
            super.onOpen();
            this.notifyConnect(this.getSession());
        }

        private void notifyConnect(ISession session) {
            try {
                this.listener.onAccept((Session)session);
            }
            catch (Throwable x) {
                LOG.info("Failure while notifying listener " + this.listener, x);
            }
        }
    }
}

