/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.hpack;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpFieldPreEncoder;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.hpack.HpackContext;
import org.eclipse.jetty.http2.hpack.Huffman;
import org.eclipse.jetty.http2.hpack.NBitInteger;
import org.eclipse.jetty.util.BufferUtil;

public class HpackFieldPreEncoder
implements HttpFieldPreEncoder {
    public HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_2;
    }

    public byte[] getEncodedField(HttpHeader header, String name, String value) {
        HpackContext.Entry entry;
        ByteBuffer buffer = BufferUtil.allocate((int)(name.length() + value.length() + 10));
        BufferUtil.clearToFill((ByteBuffer)buffer);
        buffer.put((byte)64);
        HpackContext.Entry entry2 = entry = header == null ? null : HpackContext.getStatic(header);
        if (entry == null) {
            buffer.put((byte)-128);
            NBitInteger.encode(buffer, 7, Huffman.octetsNeededLC(name));
            Huffman.encodeLC(buffer, name);
        } else {
            NBitInteger.encode(buffer, 6, entry.getSlot());
        }
        buffer.put((byte)-128);
        NBitInteger.encode(buffer, 7, Huffman.octetsNeeded(value));
        Huffman.encode(buffer, value);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        return BufferUtil.toArray((ByteBuffer)buffer);
    }
}

