/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HTTP2Flusher
extends IteratingCallback {
    private static final Logger LOG = Log.getLogger(HTTP2Flusher.class);
    private final Queue<WindowEntry> windows = new ArrayDeque<WindowEntry>();
    private final ArrayQueue<Entry> frames = new ArrayQueue(64, 32, (Object)this);
    private final Map<IStream, Integer> streams = new HashMap<IStream, Integer>();
    private final List<Entry> resets = new ArrayList<Entry>();
    private final List<Entry> actives = new ArrayList<Entry>();
    private final Queue<Entry> completes = new ArrayDeque<Entry>();
    private final HTTP2Session session;
    private final ByteBufferPool.Lease lease;

    public HTTP2Flusher(HTTP2Session session) {
        this.session = session;
        this.lease = new ByteBufferPool.Lease(session.getGenerator().getByteBufferPool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void window(IStream stream, WindowUpdateFrame frame) {
        boolean added = false;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            if (!this.isClosed()) {
                added = this.windows.offer(new WindowEntry(stream, frame));
            }
        }
        if (added) {
            this.iterate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepend(Entry entry) {
        boolean fail = false;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            if (this.isClosed()) {
                fail = true;
            } else {
                this.frames.add(0, (Object)entry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prepended {}, frames={}", new Object[]{entry, this.frames.size()});
                }
            }
        }
        if (fail) {
            this.closed(entry, new ClosedChannelException());
        }
        return !fail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(Entry entry) {
        boolean fail = false;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            if (this.isClosed()) {
                fail = true;
            } else {
                this.frames.offer((Object)entry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Appended {}, frames={}", new Object[]{entry, this.frames.size()});
                }
            }
        }
        if (fail) {
            this.closed(entry, new ClosedChannelException());
        }
        return !fail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry remove(int index) {
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            if (index == 0) {
                return (Entry)this.frames.pollUnsafe();
            }
            return (Entry)this.frames.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            return this.frames.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IteratingCallback.Action process() throws Exception {
        int i;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flushing {}", new Object[]{this.session});
        }
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            while (!this.windows.isEmpty()) {
                WindowEntry entry = this.windows.poll();
                entry.perform();
            }
            int sessionWindow = this.session.getSendWindow();
            int index = 0;
            int size = this.frames.size();
            while (index < size) {
                Entry entry = (Entry)this.frames.get(index);
                IStream stream = entry.stream;
                if (stream != null && stream.isReset() && !entry.isProtocol()) {
                    this.remove(index);
                    --size;
                    this.resets.add(entry);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Gathered for reset {}", new Object[]{entry});
                    continue;
                }
                int remaining = entry.dataRemaining();
                if (remaining > 0) {
                    FlowControlStrategy flowControl = this.session.getFlowControlStrategy();
                    if (sessionWindow <= 0) {
                        flowControl.onSessionStalled(this.session);
                        ++index;
                        continue;
                    }
                    if (stream != null) {
                        Integer streamWindow = this.streams.get(stream);
                        if (streamWindow == null) {
                            streamWindow = stream.updateSendWindow(0);
                            this.streams.put(stream, streamWindow);
                        }
                        if (streamWindow <= 0) {
                            flowControl.onStreamStalled(stream);
                            ++index;
                            continue;
                        }
                    }
                    sessionWindow -= remaining;
                    if (stream != null) {
                        this.streams.put(stream, this.streams.get(stream) - remaining);
                    }
                }
                this.remove(index);
                --size;
                this.actives.add(entry);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Gathered for write {}", new Object[]{entry});
            }
            this.streams.clear();
        }
        for (i = 0; i < this.resets.size(); ++i) {
            Entry entry = this.resets.get(i);
            entry.reset();
        }
        this.resets.clear();
        if (this.actives.isEmpty()) {
            if (this.isClosed()) {
                this.abort(new ClosedChannelException());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushed {}", new Object[]{this.session});
            }
            return IteratingCallback.Action.IDLE;
        }
        for (i = 0; i < this.actives.size(); ++i) {
            Entry entry = this.actives.get(i);
            Throwable failure = entry.generate(this.lease);
            if (failure == null) continue;
            this.failed(failure);
            return IteratingCallback.Action.SUCCEEDED;
        }
        List byteBuffers = this.lease.getByteBuffers();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing {} buffers ({} bytes) for {} frames {}", new Object[]{byteBuffers.size(), this.lease.getTotalLength(), this.actives.size(), this.actives});
        }
        this.session.getEndPoint().write((Callback)this, byteBuffers.toArray(new ByteBuffer[byteBuffers.size()]));
        return IteratingCallback.Action.SCHEDULED;
    }

    public void succeeded() {
        this.lease.recycle();
        for (int i = 0; i < this.actives.size(); ++i) {
            this.completes.add(this.actives.get(i));
        }
        this.actives.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Written {} frames for {}", new Object[]{this.completes.size(), this.completes});
        }
        while (!this.completes.isEmpty()) {
            Entry entry = this.completes.poll();
            entry.succeeded();
        }
        super.succeeded();
    }

    protected void onCompleteSuccess() {
        throw new IllegalStateException();
    }

    protected void onCompleteFailure(Throwable x) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failed", x);
        }
        this.lease.recycle();
        for (int i = 0; i < this.actives.size(); ++i) {
            this.completes.add(this.actives.get(i));
        }
        this.actives.clear();
        while (!this.completes.isEmpty()) {
            Entry entry = this.completes.poll();
            entry.failed(x);
        }
        this.abort(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort(Throwable x) {
        ArrayDeque<Entry> queued;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            queued = new ArrayDeque<Entry>((Collection<Entry>)this.frames);
            this.frames.clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Aborting, queued={}", (long)queued.size());
        }
        for (Entry entry : queued) {
            this.closed(entry, x);
        }
        this.session.abort(x);
    }

    private void closed(Entry entry, Throwable failure) {
        entry.failed(failure);
    }

    private class WindowEntry {
        private final IStream stream;
        private final WindowUpdateFrame frame;

        public WindowEntry(IStream stream, WindowUpdateFrame frame) {
            this.stream = stream;
            this.frame = frame;
        }

        public void perform() {
            FlowControlStrategy flowControl = HTTP2Flusher.this.session.getFlowControlStrategy();
            flowControl.onWindowUpdate(HTTP2Flusher.this.session, this.stream, this.frame);
        }
    }

    public static abstract class Entry
    implements Callback {
        protected final Frame frame;
        protected final IStream stream;
        protected final Callback callback;

        protected Entry(Frame frame, IStream stream, Callback callback) {
            this.frame = frame;
            this.stream = stream;
            this.callback = callback;
        }

        public int dataRemaining() {
            return 0;
        }

        public Throwable generate(ByteBufferPool.Lease lease) {
            return null;
        }

        public void reset() {
            this.failed((Throwable)new EofException("reset"));
        }

        public void failed(Throwable x) {
            if (this.stream != null) {
                this.stream.close();
                this.stream.getSession().removeStream(this.stream, true);
            }
            this.callback.failed(x);
        }

        public boolean isProtocol() {
            switch (this.frame.getType()) {
                case PRIORITY: 
                case RST_STREAM: 
                case GO_AWAY: 
                case WINDOW_UPDATE: 
                case DISCONNECT: {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

