/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class PriorityGenerator
extends FrameGenerator {
    public PriorityGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public void generate(ByteBufferPool.Lease lease, Frame frame) {
        PriorityFrame priorityFrame = (PriorityFrame)frame;
        this.generatePriority(lease, priorityFrame.getStreamId(), priorityFrame.getDependentStreamId(), priorityFrame.getWeight(), priorityFrame.isExclusive());
    }

    public void generatePriority(ByteBufferPool.Lease lease, int streamId, int dependentStreamId, int weight, boolean exclusive) {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        if (dependentStreamId < 0) {
            throw new IllegalArgumentException("Invalid dependent stream id: " + dependentStreamId);
        }
        ByteBuffer header = this.generateHeader(lease, FrameType.PRIORITY, 5, 0, dependentStreamId);
        if (exclusive) {
            streamId |= Integer.MIN_VALUE;
        }
        header.putInt(streamId);
        header.put((byte)weight);
        BufferUtil.flipToFlush((ByteBuffer)header, (int)0);
        lease.append(header, true);
    }
}

