/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.http2.parser.PrefaceParser;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ServerParser
extends Parser {
    private static final Logger LOG = Log.getLogger(ServerParser.class);
    private final Listener listener;
    private final PrefaceParser prefaceParser;
    private State state = State.PREFACE;

    public ServerParser(ByteBufferPool byteBufferPool, Listener listener, int maxHeaderTableSize, int maxHeaderSize) {
        super(byteBufferPool, listener, maxHeaderTableSize, maxHeaderSize);
        this.listener = listener;
        this.prefaceParser = new PrefaceParser(listener);
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsing {}", new Object[]{buffer});
            }
            block6: while (true) {
                switch (this.state) {
                    case PREFACE: {
                        if (!this.prefaceParser.parse(buffer)) {
                            return false;
                        }
                        if (this.onPreface()) {
                            return true;
                        }
                        this.state = State.FRAMES;
                        continue block6;
                    }
                    case FRAMES: {
                        return super.parse(buffer);
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Throwable x) {
            LOG.debug(x);
            this.notifyConnectionFailure(1, "parser_error");
            return false;
        }
    }

    protected boolean onPreface() {
        return this.notifyPreface();
    }

    private boolean notifyPreface() {
        try {
            return this.listener.onPreface();
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return false;
        }
    }

    private static enum State {
        PREFACE,
        FRAMES;

    }

    public static interface Listener
    extends Parser.Listener {
        public boolean onPreface();

        public static class Adapter
        extends Parser.Listener.Adapter
        implements Listener {
            @Override
            public boolean onPreface() {
                return false;
            }
        }
    }
}

