/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.parser.BodyParser;
import org.eclipse.jetty.http2.parser.HeaderParser;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.util.BufferUtil;

public class DataBodyParser
extends BodyParser {
    private State state = State.PREPARE;
    private int padding;
    private int paddingLength;
    private int length;

    public DataBodyParser(HeaderParser headerParser, Parser.Listener listener) {
        super(headerParser, listener);
    }

    private void reset() {
        this.state = State.PREPARE;
        this.padding = 0;
        this.paddingLength = 0;
        this.length = 0;
    }

    @Override
    protected boolean emptyBody() {
        if (this.isPadding()) {
            this.notifyConnectionFailure(1, "invalid_data_frame");
            return false;
        }
        return this.onData(BufferUtil.EMPTY_BUFFER, false, 0);
    }

    @Override
    public BodyParser.Result parse(ByteBuffer buffer) {
        boolean loop = false;
        block6: while (buffer.hasRemaining() || loop) {
            switch (this.state) {
                case PREPARE: {
                    if (this.getStreamId() == 0) {
                        return this.notifyConnectionFailure(1, "invalid_data_frame");
                    }
                    this.length = this.getBodyLength();
                    if (this.isPadding()) {
                        this.state = State.PADDING_LENGTH;
                        continue block6;
                    }
                    this.state = State.DATA;
                    continue block6;
                }
                case PADDING_LENGTH: {
                    this.padding = 1;
                    this.paddingLength = buffer.get() & 0xFF;
                    --this.length;
                    this.length -= this.paddingLength;
                    this.state = State.DATA;
                    boolean bl = loop = this.length == 0;
                    if (this.length >= 0) continue block6;
                    return this.notifyConnectionFailure(6, "invalid_data_frame_padding");
                }
                case DATA: {
                    int size = Math.min(buffer.remaining(), this.length);
                    int position = buffer.position();
                    int limit = buffer.limit();
                    buffer.limit(position + size);
                    ByteBuffer slice = buffer.slice();
                    buffer.limit(limit);
                    buffer.position(position + size);
                    this.length -= size;
                    if (this.length == 0) {
                        this.state = State.PADDING;
                        boolean bl = loop = this.paddingLength == 0;
                        if (!this.onData(slice, false, this.padding + this.paddingLength)) continue block6;
                        return BodyParser.Result.ASYNC;
                    }
                    if (!this.onData(slice, true, 0)) continue block6;
                    return BodyParser.Result.ASYNC;
                }
                case PADDING: {
                    int size = Math.min(buffer.remaining(), this.paddingLength);
                    buffer.position(buffer.position() + size);
                    this.paddingLength -= size;
                    if (this.paddingLength != 0) continue block6;
                    this.reset();
                    return BodyParser.Result.COMPLETE;
                }
            }
            throw new IllegalStateException();
        }
        return BodyParser.Result.PENDING;
    }

    private boolean onData(ByteBuffer buffer, boolean fragment, int padding) {
        DataFrame frame = new DataFrame(this.getStreamId(), buffer, !fragment && this.isEndStream(), padding);
        return this.notifyData(frame);
    }

    private static enum State {
        PREPARE,
        PADDING_LENGTH,
        DATA,
        PADDING;

    }
}

