/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http2.CloseState;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.io.IdleTimeout;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HTTP2Stream
extends IdleTimeout
implements IStream {
    private static final Logger LOG = Log.getLogger(HTTP2Stream.class);
    private final AtomicReference<ConcurrentMap<String, Object>> attributes = new AtomicReference();
    private final AtomicReference<CloseState> closeState = new AtomicReference<CloseState>(CloseState.NOT_CLOSED);
    private final AtomicInteger sendWindow = new AtomicInteger();
    private final AtomicInteger recvWindow = new AtomicInteger();
    private final ISession session;
    private final int streamId;
    private volatile Stream.Listener listener;
    private volatile boolean reset;

    public HTTP2Stream(Scheduler scheduler, ISession session, int streamId) {
        super(scheduler);
        this.session = session;
        this.streamId = streamId;
    }

    @Override
    public int getId() {
        return this.streamId;
    }

    @Override
    public ISession getSession() {
        return this.session;
    }

    @Override
    public void headers(HeadersFrame frame, Callback callback) {
        this.notIdle();
        this.session.control(this, callback, frame, Frame.EMPTY_ARRAY);
    }

    @Override
    public void push(PushPromiseFrame frame, Promise<Stream> promise) {
        this.notIdle();
        this.session.push(this, promise, frame);
    }

    @Override
    public void data(DataFrame frame, Callback callback) {
        this.notIdle();
        this.session.data(this, callback, frame);
    }

    @Override
    public void reset(ResetFrame frame, Callback callback) {
        this.notIdle();
        this.session.control(this, callback, frame, Frame.EMPTY_ARRAY);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes().get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes().put(key, value);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes().remove(key);
    }

    @Override
    public boolean isReset() {
        return this.reset;
    }

    @Override
    public boolean isClosed() {
        return this.closeState.get() == CloseState.CLOSED;
    }

    public boolean isOpen() {
        return !this.isClosed();
    }

    protected void onIdleExpired(TimeoutException timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Idle timeout {}ms expired on {}", new Object[]{this.getIdleTimeout(), this});
        }
        this.close();
        this.reset(new ResetFrame(this.getId(), 8), (Callback)Callback.Adapter.INSTANCE);
        this.notifyFailure(this, timeout);
    }

    private ConcurrentMap<String, Object> attributes() {
        ConcurrentMap<String, Object> map = this.attributes.get();
        if (map == null && !this.attributes.compareAndSet(null, map = new ConcurrentHashMap<String, Object>())) {
            map = this.attributes.get();
        }
        return map;
    }

    @Override
    public Stream.Listener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(Stream.Listener listener) {
        this.listener = listener;
    }

    @Override
    public boolean process(Frame frame, Callback callback) {
        this.notIdle();
        switch (frame.getType()) {
            case HEADERS: {
                return this.onHeaders((HeadersFrame)frame, callback);
            }
            case DATA: {
                return this.onData((DataFrame)frame, callback);
            }
            case RST_STREAM: {
                return this.onReset((ResetFrame)frame, callback);
            }
            case PUSH_PROMISE: {
                return this.onPush((PushPromiseFrame)frame, callback);
            }
        }
        throw new UnsupportedOperationException();
    }

    private boolean onHeaders(HeadersFrame frame, Callback callback) {
        callback.succeeded();
        return false;
    }

    private boolean onData(DataFrame frame, Callback callback) {
        if (this.getRecvWindow() < 0) {
            this.session.close(3, "stream_window_exceeded", callback);
            return true;
        }
        this.notifyData(this, frame, callback);
        return false;
    }

    private boolean onReset(ResetFrame frame, Callback callback) {
        this.reset = true;
        callback.succeeded();
        return false;
    }

    private boolean onPush(PushPromiseFrame frame, Callback callback) {
        callback.succeeded();
        return false;
    }

    @Override
    public void updateClose(boolean update, boolean local) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Update close for {} close={} local={}", new Object[]{this, update, local});
        }
        if (!update) {
            return;
        }
        block5: while (true) {
            CloseState current = this.closeState.get();
            switch (current) {
                case NOT_CLOSED: {
                    CloseState newValue;
                    if (!this.closeState.compareAndSet(current, newValue = local ? CloseState.LOCALLY_CLOSED : CloseState.REMOTELY_CLOSED)) continue block5;
                    return;
                }
                case LOCALLY_CLOSED: {
                    if (!local) {
                        this.close();
                    }
                    return;
                }
                case REMOTELY_CLOSED: {
                    if (local) {
                        this.close();
                    }
                    return;
                }
            }
            break;
        }
    }

    @Override
    public int getSendWindow() {
        return this.sendWindow.get();
    }

    protected int getRecvWindow() {
        return this.recvWindow.get();
    }

    @Override
    public int updateSendWindow(int delta) {
        return this.sendWindow.getAndAdd(delta);
    }

    @Override
    public int updateRecvWindow(int delta) {
        return this.recvWindow.getAndAdd(delta);
    }

    @Override
    public void close() {
        this.closeState.set(CloseState.CLOSED);
        this.onClose();
    }

    protected void notifyData(Stream stream, DataFrame frame, Callback callback) {
        Stream.Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        try {
            listener.onData(stream, frame, callback);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + listener, x);
        }
    }

    private void notifyFailure(Stream stream, Throwable failure) {
        Stream.Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        try {
            listener.onFailure(stream, failure);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + listener, x);
        }
    }

    public String toString() {
        return String.format("%s@%x{id=%d,sendWindow=%s,recvWindow=%s,reset=%b,%s}", this.getClass().getSimpleName(), this.hashCode(), this.getId(), this.sendWindow, this.recvWindow, this.reset, this.closeState);
    }
}

