/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.PingFrame;
import org.eclipse.jetty.http2.parser.BodyParser;
import org.eclipse.jetty.http2.parser.HeaderParser;
import org.eclipse.jetty.http2.parser.Parser;

public class PingBodyParser
extends BodyParser {
    private State state = State.PREPARE;
    private int cursor;
    private byte[] payload;

    public PingBodyParser(HeaderParser headerParser, Parser.Listener listener) {
        super(headerParser, listener);
    }

    private void reset() {
        this.state = State.PREPARE;
        this.cursor = 0;
        this.payload = null;
    }

    @Override
    public BodyParser.Result parse(ByteBuffer buffer) {
        block5: while (buffer.hasRemaining()) {
            switch (this.state) {
                case PREPARE: {
                    if (this.getStreamId() != 0) {
                        return this.notifyConnectionFailure(1, "invalid_ping_frame");
                    }
                    if (this.getBodyLength() != 8) {
                        return this.notifyConnectionFailure(6, "invalid_ping_frame");
                    }
                    this.state = State.PAYLOAD;
                    continue block5;
                }
                case PAYLOAD: {
                    this.payload = new byte[8];
                    if (buffer.remaining() >= 8) {
                        buffer.get(this.payload);
                        return this.onPing(this.payload);
                    }
                    this.state = State.PAYLOAD_BYTES;
                    this.cursor = 8;
                    continue block5;
                }
                case PAYLOAD_BYTES: {
                    this.payload[8 - this.cursor] = buffer.get();
                    --this.cursor;
                    if (this.cursor != 0) continue block5;
                    return this.onPing(this.payload);
                }
            }
            throw new IllegalStateException();
        }
        return BodyParser.Result.PENDING;
    }

    private BodyParser.Result onPing(byte[] payload) {
        PingFrame frame = new PingFrame(payload, this.hasFlag(1));
        this.reset();
        return this.notifyPing(frame) ? BodyParser.Result.ASYNC : BodyParser.Result.COMPLETE;
    }

    private static enum State {
        PREPARE,
        PAYLOAD,
        PAYLOAD_BYTES;

    }
}

