/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PingFrame;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.parser.HeaderParser;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class BodyParser {
    protected static final Logger LOG = Log.getLogger(BodyParser.class);
    private final HeaderParser headerParser;
    private final Parser.Listener listener;

    protected BodyParser(HeaderParser headerParser, Parser.Listener listener) {
        this.headerParser = headerParser;
        this.listener = listener;
    }

    public abstract Result parse(ByteBuffer var1);

    protected boolean emptyBody() {
        this.notifyConnectionFailure(1, "invalid_frame");
        return false;
    }

    protected boolean hasFlag(int bit) {
        return this.headerParser.hasFlag(bit);
    }

    protected boolean isPadding() {
        return this.headerParser.hasFlag(8);
    }

    protected boolean isEndStream() {
        return this.headerParser.hasFlag(1);
    }

    protected int getStreamId() {
        return this.headerParser.getStreamId();
    }

    protected int getBodyLength() {
        return this.headerParser.getLength();
    }

    protected boolean notifyData(DataFrame frame) {
        try {
            return this.listener.onData(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return false;
        }
    }

    protected boolean notifyHeaders(HeadersFrame frame) {
        try {
            return this.listener.onHeaders(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return false;
        }
    }

    protected boolean notifyPriority(PriorityFrame frame) {
        try {
            return this.listener.onPriority(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return false;
        }
    }

    protected boolean notifyReset(ResetFrame frame) {
        try {
            return this.listener.onReset(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return false;
        }
    }

    protected boolean notifySettings(SettingsFrame frame) {
        try {
            return this.listener.onSettings(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return false;
        }
    }

    protected boolean notifyPushPromise(PushPromiseFrame frame) {
        try {
            return this.listener.onPushPromise(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return false;
        }
    }

    protected boolean notifyPing(PingFrame frame) {
        try {
            return this.listener.onPing(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return false;
        }
    }

    protected boolean notifyGoAway(GoAwayFrame frame) {
        try {
            return this.listener.onGoAway(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return false;
        }
    }

    protected boolean notifyWindowUpdate(WindowUpdateFrame frame) {
        try {
            return this.listener.onWindowUpdate(frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return false;
        }
    }

    protected Result notifyConnectionFailure(int error, String reason) {
        try {
            this.listener.onConnectionFailure(error, reason);
            return Result.ASYNC;
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
            return Result.ASYNC;
        }
    }

    public static enum Result {
        PENDING,
        ASYNC,
        COMPLETE;

    }
}

