/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import org.eclipse.jetty.http2.FlowControl;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HTTP2FlowControl
implements FlowControl {
    private static final Logger LOG = Log.getLogger(HTTP2FlowControl.class);
    private int initialStreamWindow;

    public HTTP2FlowControl(int initialStreamWindow) {
        this.initialStreamWindow = initialStreamWindow;
    }

    @Override
    public void onNewStream(IStream stream) {
        stream.updateSendWindow(this.initialStreamWindow);
        stream.updateRecvWindow(65535);
    }

    @Override
    public void updateInitialStreamWindow(ISession session, int initialStreamWindow) {
        int initialWindow = this.initialStreamWindow;
        this.initialStreamWindow = initialStreamWindow;
        int delta = initialStreamWindow - initialWindow;
        for (Stream stream : session.getStreams()) {
            session.onWindowUpdate((IStream)stream, new WindowUpdateFrame(stream.getId(), delta));
        }
    }

    @Override
    public void onWindowUpdate(ISession session, IStream stream, WindowUpdateFrame frame) {
        int delta = frame.getWindowDelta();
        if (frame.getStreamId() > 0) {
            if (stream != null) {
                int oldSize = stream.updateSendWindow(delta);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updated stream send window {} -> {} for {}", new Object[]{oldSize, oldSize + delta, stream});
                }
            }
        } else {
            int oldSize = session.updateSendWindow(delta);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated session send window {} -> {} for {}", new Object[]{oldSize, oldSize + delta, session});
            }
        }
    }

    @Override
    public void onDataReceived(ISession session, IStream stream, int length) {
        int oldSize = session.updateRecvWindow(-length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated session recv window {} -> {} for {}", new Object[]{oldSize, oldSize - length, session});
        }
        if (stream != null) {
            oldSize = stream.updateRecvWindow(-length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated stream recv window {} -> {} for {}", new Object[]{oldSize, oldSize - length, stream});
            }
        }
    }

    @Override
    public void onDataConsumed(IStream stream, int length) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Data consumed, increasing windows by {} for {}", new Object[]{length, stream});
        }
        if (length > 0) {
            ISession session = stream.getSession();
            session.updateRecvWindow(length);
            stream.updateRecvWindow(length);
            WindowUpdateFrame frame = new WindowUpdateFrame(-stream.getId(), length);
            session.control(stream, (Callback)Callback.Adapter.INSTANCE, frame, Frame.EMPTY_ARRAY);
        }
    }

    @Override
    public void onDataSending(IStream stream, int length) {
        if (length == 0) {
            return;
        }
        ISession session = stream.getSession();
        int oldSize = session.updateSendWindow(-length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated session send window {} -> {} for {}", new Object[]{oldSize, oldSize - length, session});
        }
        oldSize = stream.updateSendWindow(-length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated stream send window {} -> {} for {}", new Object[]{oldSize, oldSize - length, stream});
        }
    }

    @Override
    public void onDataSent(IStream stream, int length) {
    }

    @Override
    public void onSessionStalled(ISession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session stalled {}", new Object[]{session});
        }
    }

    @Override
    public void onStreamStalled(IStream stream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stream stalled {}", new Object[]{stream});
        }
    }
}

