/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.eclipse.jetty.http2.FlowControl;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HTTP2Flusher
extends IteratingCallback {
    private static final Logger LOG = Log.getLogger(HTTP2Flusher.class);
    private final Deque<WindowEntry> windows = new ArrayDeque<WindowEntry>();
    private final ArrayQueue<Entry> frames = new ArrayQueue(64, 32, (Object)this);
    private final Map<IStream, Integer> streams = new HashMap<IStream, Integer>();
    private final List<Entry> reset = new ArrayList<Entry>();
    private final HTTP2Session session;
    private final ByteBufferPool.Lease lease;
    private final List<Entry> active;
    private final Queue<Entry> complete;

    public HTTP2Flusher(HTTP2Session session) {
        this.session = session;
        this.lease = new ByteBufferPool.Lease(session.getGenerator().getByteBufferPool());
        this.active = new ArrayList<Entry>();
        this.complete = new ArrayDeque<Entry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void window(IStream stream, WindowUpdateFrame frame) {
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            if (!this.isClosed()) {
                this.windows.offer(new WindowEntry(stream, frame));
                this.iterate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepend(Entry entry) {
        boolean fail = false;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            if (this.isClosed()) {
                fail = true;
            } else {
                this.frames.add(0, (Object)entry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prepended {}, frames={}", new Object[]{entry, this.frames.size()});
                }
            }
        }
        if (fail) {
            this.closed(entry, new ClosedChannelException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Entry entry) {
        boolean fail = false;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            if (this.isClosed()) {
                fail = true;
            } else {
                this.frames.offer((Object)entry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Appended {}, frames={}", new Object[]{entry, this.frames.size()});
                }
            }
        }
        if (fail) {
            this.closed(entry, new ClosedChannelException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            return this.frames.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IteratingCallback.Action process() throws Exception {
        int i;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flushing {}", new Object[]{this.session});
        }
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            while (!this.windows.isEmpty()) {
                WindowEntry entry = this.windows.poll();
                entry.perform();
            }
            int sessionWindow = this.session.getSendWindow();
            int index = 0;
            int size = this.frames.size();
            while (index < size) {
                Entry entry = (Entry)this.frames.get(index);
                IStream stream = entry.stream;
                int remaining = entry.dataRemaining();
                if (remaining > 0) {
                    if (sessionWindow <= 0) {
                        this.session.getFlowControl().onSessionStalled(this.session);
                        ++index;
                        continue;
                    }
                    Integer streamWindow = this.streams.get(stream);
                    if (streamWindow == null) {
                        streamWindow = stream.getSendWindow();
                        this.streams.put(stream, streamWindow);
                    }
                    if (streamWindow <= 0) {
                        this.session.getFlowControl().onStreamStalled(stream);
                        ++index;
                        continue;
                    }
                }
                if (index == 0) {
                    this.frames.pollUnsafe();
                } else {
                    this.frames.remove(index);
                }
                --size;
                if (stream != null && stream.isReset()) {
                    this.reset.add(entry);
                    continue;
                }
                if (remaining > 0) {
                    sessionWindow -= remaining;
                    this.streams.put(stream, this.streams.get(stream) - remaining);
                }
                this.active.add(entry);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Gathered {}", new Object[]{entry});
            }
            this.streams.clear();
        }
        for (i = 0; i < this.reset.size(); ++i) {
            Entry entry = this.reset.get(i);
            entry.reset();
        }
        this.reset.clear();
        if (this.active.isEmpty()) {
            if (this.isClosed()) {
                this.terminate(new ClosedChannelException());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushed {}", new Object[]{this.session});
            }
            return IteratingCallback.Action.IDLE;
        }
        for (i = 0; i < this.active.size(); ++i) {
            Entry entry = this.active.get(i);
            Throwable failure = entry.generate(this.lease);
            if (failure == null) continue;
            this.failed(failure);
            return IteratingCallback.Action.SUCCEEDED;
        }
        List byteBuffers = this.lease.getByteBuffers();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing {} buffers ({} bytes) for {} frames {}", new Object[]{byteBuffers.size(), this.lease.getTotalLength(), this.active.size(), this.active});
        }
        this.session.getEndPoint().write((Callback)this, byteBuffers.toArray(new ByteBuffer[byteBuffers.size()]));
        return IteratingCallback.Action.SCHEDULED;
    }

    public void succeeded() {
        this.lease.recycle();
        for (int i = 0; i < this.active.size(); ++i) {
            this.complete.add(this.active.get(i));
        }
        this.active.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Written {} frames for {}", new Object[]{this.complete.size(), this.complete});
        }
        while (!this.complete.isEmpty()) {
            Entry entry = this.complete.poll();
            entry.succeeded();
        }
        super.succeeded();
    }

    protected void onCompleteSuccess() {
        throw new IllegalStateException();
    }

    protected void onCompleteFailure(Throwable x) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(x);
        }
        this.lease.recycle();
        for (int i = 0; i < this.active.size(); ++i) {
            this.complete.add(this.active.get(i));
        }
        this.active.clear();
        while (!this.complete.isEmpty()) {
            Entry entry = this.complete.poll();
            entry.failed(x);
        }
        this.terminate(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate(Throwable x) {
        ArrayDeque<Entry> queued;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            queued = new ArrayDeque<Entry>((Collection<Entry>)this.frames);
            this.frames.clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminating, queued={}", (long)queued.size());
        }
        for (Entry entry : queued) {
            this.closed(entry, x);
        }
    }

    private void closed(Entry entry, Throwable failure) {
        entry.failed(failure);
    }

    private class WindowEntry {
        private final IStream stream;
        private final WindowUpdateFrame frame;

        public WindowEntry(IStream stream, WindowUpdateFrame frame) {
            this.stream = stream;
            this.frame = frame;
        }

        public void perform() {
            FlowControl flowControl = HTTP2Flusher.this.session.getFlowControl();
            flowControl.onWindowUpdate(HTTP2Flusher.this.session, this.stream, this.frame);
        }
    }

    public static abstract class Entry
    implements Callback {
        protected final Frame frame;
        protected final IStream stream;
        protected final Callback callback;

        protected Entry(Frame frame, IStream stream, Callback callback) {
            this.frame = frame;
            this.stream = stream;
            this.callback = callback;
        }

        public int dataRemaining() {
            return 0;
        }

        public Throwable generate(ByteBufferPool.Lease lease) {
            return null;
        }

        public void reset() {
            this.failed((Throwable)new EofException("reset"));
        }

        public void failed(Throwable x) {
            this.callback.failed(x);
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

