/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.jetty.alpn.client.ALPNClientConnectionFactory;
import org.eclipse.jetty.http2.BufferingFlowControlStrategy;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.HTTP2ClientConnectionFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;

@ManagedObject
public class HTTP2Client
extends ContainerLifeCycle {
    private final ClientConnector connector;
    private int inputBufferSize = 8192;
    private List<String> protocols = List.of("h2");
    private int initialSessionRecvWindow = 0x1000000;
    private int initialStreamRecvWindow = 0x800000;
    private int maxFrameLength = 16384;
    private int maxConcurrentPushedStreams = 32;
    private int maxSettingsKeys = 64;
    private FlowControlStrategy.Factory flowControlStrategyFactory = () -> new BufferingFlowControlStrategy(0.5f);
    private long streamIdleTimeout;
    private boolean useInputDirectByteBuffers = true;
    private boolean useOutputDirectByteBuffers = true;

    public HTTP2Client() {
        this(new ClientConnector());
    }

    public HTTP2Client(ClientConnector connector) {
        this.connector = connector;
        this.addBean(connector);
    }

    public ClientConnector getClientConnector() {
        return this.connector;
    }

    public Executor getExecutor() {
        return this.connector.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.connector.setExecutor(executor);
    }

    public Scheduler getScheduler() {
        return this.connector.getScheduler();
    }

    public void setScheduler(Scheduler scheduler) {
        this.connector.setScheduler(scheduler);
    }

    public ByteBufferPool getByteBufferPool() {
        return this.connector.getByteBufferPool();
    }

    public void setByteBufferPool(ByteBufferPool bufferPool) {
        this.connector.setByteBufferPool(bufferPool);
    }

    public FlowControlStrategy.Factory getFlowControlStrategyFactory() {
        return this.flowControlStrategyFactory;
    }

    public void setFlowControlStrategyFactory(FlowControlStrategy.Factory flowControlStrategyFactory) {
        this.flowControlStrategyFactory = flowControlStrategyFactory;
    }

    @ManagedAttribute(value="The number of selectors")
    public int getSelectors() {
        return this.connector.getSelectors();
    }

    public void setSelectors(int selectors) {
        this.connector.setSelectors(selectors);
    }

    @ManagedAttribute(value="The idle timeout in milliseconds")
    public long getIdleTimeout() {
        return this.connector.getIdleTimeout().toMillis();
    }

    public void setIdleTimeout(long idleTimeout) {
        this.connector.setIdleTimeout(Duration.ofMillis(idleTimeout));
    }

    @ManagedAttribute(value="The stream idle timeout in milliseconds")
    public long getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    public void setStreamIdleTimeout(long streamIdleTimeout) {
        this.streamIdleTimeout = streamIdleTimeout;
    }

    @ManagedAttribute(value="The connect timeout in milliseconds")
    public long getConnectTimeout() {
        return this.connector.getConnectTimeout().toMillis();
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connector.setConnectTimeout(Duration.ofMillis(connectTimeout));
    }

    @ManagedAttribute(value="Whether the connect() operation is blocking")
    public boolean isConnectBlocking() {
        return this.connector.isConnectBlocking();
    }

    public void setConnectBlocking(boolean connectBlocking) {
        this.connector.setConnectBlocking(connectBlocking);
    }

    public SocketAddress getBindAddress() {
        return this.connector.getBindAddress();
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.connector.setBindAddress(bindAddress);
    }

    @ManagedAttribute(value="The size of the buffer used to read from the network")
    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    @ManagedAttribute(value="The ALPN protocol list")
    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    @ManagedAttribute(value="The initial size of session's flow control receive window")
    public int getInitialSessionRecvWindow() {
        return this.initialSessionRecvWindow;
    }

    public void setInitialSessionRecvWindow(int initialSessionRecvWindow) {
        this.initialSessionRecvWindow = initialSessionRecvWindow;
    }

    @ManagedAttribute(value="The initial size of stream's flow control receive window")
    public int getInitialStreamRecvWindow() {
        return this.initialStreamRecvWindow;
    }

    public void setInitialStreamRecvWindow(int initialStreamRecvWindow) {
        this.initialStreamRecvWindow = initialStreamRecvWindow;
    }

    @ManagedAttribute(value="The max frame length in bytes")
    public int getMaxFrameLength() {
        return this.maxFrameLength;
    }

    public void setMaxFrameLength(int maxFrameLength) {
        this.maxFrameLength = maxFrameLength;
    }

    @ManagedAttribute(value="The max number of concurrent pushed streams")
    public int getMaxConcurrentPushedStreams() {
        return this.maxConcurrentPushedStreams;
    }

    public void setMaxConcurrentPushedStreams(int maxConcurrentPushedStreams) {
        this.maxConcurrentPushedStreams = maxConcurrentPushedStreams;
    }

    @ManagedAttribute(value="The max number of keys in all SETTINGS frames")
    public int getMaxSettingsKeys() {
        return this.maxSettingsKeys;
    }

    public void setMaxSettingsKeys(int maxSettingsKeys) {
        this.maxSettingsKeys = maxSettingsKeys;
    }

    @ManagedAttribute(value="Whether to use direct ByteBuffers for reading")
    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    @ManagedAttribute(value="Whether to use direct ByteBuffers for writing")
    public boolean isUseOutputDirectByteBuffers() {
        return this.useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    public void connect(InetSocketAddress address, Session.Listener listener, Promise<Session> promise) {
        this.connect(null, address, listener, promise);
    }

    public void connect(SslContextFactory sslContextFactory, InetSocketAddress address, Session.Listener listener, Promise<Session> promise) {
        this.connect(sslContextFactory, address, listener, promise, null);
    }

    public void connect(SslContextFactory sslContextFactory, InetSocketAddress address, Session.Listener listener, Promise<Session> promise, Map<String, Object> context) {
        ClientConnectionFactory factory = this.newClientConnectionFactory(sslContextFactory);
        this.connect(address, factory, listener, promise, context);
    }

    public void connect(SocketAddress address, ClientConnectionFactory factory, Session.Listener listener, Promise<Session> promise, Map<String, Object> context) {
        context = this.contextFrom(factory, listener, promise, context);
        context.put("org.eclipse.jetty.client.connector.connectionPromise", promise);
        this.connector.connect(address, context);
    }

    public void accept(SslContextFactory sslContextFactory, SocketChannel channel, Session.Listener listener, Promise<Session> promise) {
        ClientConnectionFactory factory = this.newClientConnectionFactory(sslContextFactory);
        this.accept(channel, factory, listener, promise);
    }

    public void accept(SocketChannel channel, ClientConnectionFactory factory, Session.Listener listener, Promise<Session> promise) {
        Map<String, Object> context = this.contextFrom(factory, listener, promise, null);
        context.put("org.eclipse.jetty.client.connector.connectionPromise", promise);
        this.connector.accept(channel, context);
    }

    private Map<String, Object> contextFrom(ClientConnectionFactory factory, Session.Listener listener, Promise<Session> promise, Map<String, Object> context) {
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("org.eclipse.jetty.client.http2", (Object)this);
        context.put("org.eclipse.jetty.client.http2.sessionListener", listener);
        context.put("org.eclipse.jetty.client.http2.sessionPromise", promise);
        context.put("org.eclipse.jetty.client.connector.clientConnectionFactory", factory);
        return context;
    }

    private ClientConnectionFactory newClientConnectionFactory(SslContextFactory sslContextFactory) {
        HTTP2ClientConnectionFactory factory = new HTTP2ClientConnectionFactory();
        if (sslContextFactory != null) {
            ALPNClientConnectionFactory alpn = new ALPNClientConnectionFactory(this.getExecutor(), (ClientConnectionFactory)factory, this.getProtocols());
            factory = new SslClientConnectionFactory(sslContextFactory, this.getByteBufferPool(), this.getExecutor(), (ClientConnectionFactory)alpn);
        }
        return factory;
    }
}

