/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpChannelOverFCGI
extends HttpChannel<ByteBuffer> {
    private static final Logger LOG = Log.getLogger(HttpChannelOverFCGI.class);
    private final List<HttpField> fields = new ArrayList<HttpField>();
    private final Dispatcher dispatcher;
    private String method;
    private String path;
    private String query;
    private String version;

    public HttpChannelOverFCGI(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransport transport, HttpInput<ByteBuffer> input) {
        super(connector, configuration, endPoint, transport, input);
        this.dispatcher = new Dispatcher(connector.getExecutor(), (Runnable)((Object)this));
    }

    protected void header(HttpField field) {
        if ("REQUEST_METHOD".equalsIgnoreCase(field.getName())) {
            this.method = field.getValue();
        } else if ("DOCUMENT_URI".equalsIgnoreCase(field.getName())) {
            this.path = field.getValue();
        } else if ("QUERY_STRING".equalsIgnoreCase(field.getName())) {
            this.query = field.getValue();
        } else if ("SERVER_PROTOCOL".equalsIgnoreCase(field.getName())) {
            this.version = field.getValue();
        } else {
            this.fields.add(field);
        }
    }

    public boolean headerComplete() {
        String uri = this.path;
        if (this.query != null && this.query.length() > 0) {
            uri = uri + "?" + this.query;
        }
        this.startRequest(HttpMethod.fromString((String)this.method), this.method, ByteBuffer.wrap(uri.getBytes(StandardCharsets.UTF_8)), HttpVersion.fromString((String)this.version));
        for (HttpField fcgiField : this.fields) {
            HttpField httpField = this.convertHeader(fcgiField);
            if (httpField == null) continue;
            this.parsedHeader(httpField);
        }
        return super.headerComplete();
    }

    private HttpField convertHeader(HttpField field) {
        String name = field.getName();
        if (name.startsWith("HTTP_")) {
            String[] parts = name.split("_");
            StringBuilder httpName = new StringBuilder();
            for (int i = 1; i < parts.length; ++i) {
                if (i > 1) {
                    httpName.append("-");
                }
                String part = parts[i];
                httpName.append(Character.toUpperCase(part.charAt(0)));
                httpName.append(part.substring(1).toLowerCase(Locale.ENGLISH));
            }
            return new HttpField(httpName.toString(), field.getValue());
        }
        return null;
    }

    protected void dispatch() {
        this.dispatcher.dispatch();
    }

    private static class Dispatcher
    implements Runnable {
        private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
        private final Executor executor;
        private final Runnable runnable;

        private Dispatcher(Executor executor, Runnable runnable) {
            this.executor = executor;
            this.runnable = runnable;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void dispatch() {
            block5: while (true) {
                State current = this.state.get();
                LOG.debug("Dispatching, state={}", new Object[]{current});
                switch (current) {
                    case IDLE: {
                        if (!this.state.compareAndSet(current, State.DISPATCH)) continue block5;
                        this.executor.execute(this);
                        return;
                    }
                    case DISPATCH: 
                    case EXECUTE: {
                        if (this.state.compareAndSet(current, State.SCHEDULE)) return;
                        continue block5;
                    }
                    case SCHEDULE: {
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            block5: while (true) {
                State current = this.state.get();
                LOG.debug("Running, state={}", new Object[]{current});
                switch (current) {
                    case DISPATCH: {
                        if (!this.state.compareAndSet(current, State.EXECUTE)) continue block5;
                        this.runnable.run();
                        continue block5;
                    }
                    case EXECUTE: {
                        if (!this.state.compareAndSet(current, State.IDLE)) continue block5;
                        return;
                    }
                    case SCHEDULE: {
                        if (!this.state.compareAndSet(current, State.DISPATCH)) throw new IllegalStateException();
                        continue block5;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }

        private static enum State {
            IDLE,
            DISPATCH,
            EXECUTE,
            SCHEDULE;

        }
    }
}

