/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server;

import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.fcgi.server.ServerFCGIConnection;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelOverFCGI
extends HttpChannel {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannelOverFCGI.class);
    private static final HttpInput.Content EOF_CONTENT = new HttpInput.EofContent();
    private final Callback asyncFillCallback = new AsyncFillCallback();
    private final ServerFCGIConnection connection;
    private final HttpFields.Mutable fields = HttpFields.build();
    private final Dispatcher dispatcher;
    private HttpInput.Content normalContent;
    private HttpInput.Content specialContent;
    private String method;
    private String path;
    private String query;
    private String version;
    private HostPortHttpField hostPort;

    public HttpChannelOverFCGI(ServerFCGIConnection connection, Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransport transport) {
        super(connector, configuration, endPoint, transport);
        this.connection = connection;
        this.dispatcher = new Dispatcher((Executor)connector.getServer().getThreadPool(), (Runnable)((Object)this));
    }

    public boolean onContent(HttpInput.Content content) {
        Throwable failure;
        boolean result = super.onContent(content);
        HttpInput.Content special = this.specialContent;
        Throwable throwable = failure = special == null ? null : special.getError();
        if (failure == null) {
            if (this.normalContent != null) {
                throw new IllegalStateException("onContent has unconsumed content");
            }
            this.normalContent = content;
        } else {
            content.failed(failure);
        }
        return result;
    }

    public boolean needContent() {
        if (this.hasContent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("needContent has immediate content {}", (Object)this);
            }
            return true;
        }
        this.parseAndFill();
        if (this.hasContent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("needContent has parsed content {}", (Object)this);
            }
            return true;
        }
        this.connection.getEndPoint().tryFillInterested(this.asyncFillCallback);
        return false;
    }

    private boolean hasContent() {
        return this.specialContent != null || this.normalContent != null;
    }

    public HttpInput.Content produceContent() {
        if (!this.hasContent()) {
            this.parseAndFill();
        }
        if (!this.hasContent()) {
            return null;
        }
        HttpInput.Content content = this.normalContent;
        if (content != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("produceContent produced {} {}", (Object)content, (Object)this);
            }
            this.normalContent = null;
            return content;
        }
        content = this.specialContent;
        if (LOG.isDebugEnabled()) {
            LOG.debug("produceContent produced special {} {}", (Object)content, (Object)this);
        }
        return content;
    }

    private void parseAndFill() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("parseAndFill {}", (Object)this);
        }
        this.connection.parseAndFill();
    }

    public boolean failAllContent(Throwable failure) {
        HttpInput.Content special;
        HttpInput.Content normal;
        if (LOG.isDebugEnabled()) {
            LOG.debug("failing all content {}", (Object)this);
        }
        if ((normal = this.normalContent) != null) {
            normal.failed(failure);
        }
        if ((special = this.specialContent) != null) {
            return special.isEof();
        }
        HttpInput.Content content;
        while ((content = this.produceContent()) != null) {
            special = this.specialContent;
            if (special != null) {
                return special.isEof();
            }
            content.failed(failure);
        }
        return false;
    }

    public boolean failed(Throwable x) {
        HttpInput.Content special;
        Throwable error;
        if (LOG.isDebugEnabled()) {
            LOG.debug("failed {}", (Object)this, (Object)x);
        }
        Throwable throwable = error = (special = this.specialContent) == null ? null : special.getError();
        if (error != null && error != x) {
            error.addSuppressed(x);
        } else {
            this.specialContent = new HttpInput.ErrorContent(x);
        }
        return this.getRequest().getHttpInput().onContentProducible();
    }

    protected boolean eof() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("received EOF");
        }
        this.specialContent = EOF_CONTENT;
        return this.getRequest().getHttpInput().onContentProducible();
    }

    protected void header(HttpField field) {
        String name = field.getName();
        String value = field.getValue();
        this.getRequest().setAttribute(name, (Object)value);
        if ("REQUEST_METHOD".equalsIgnoreCase(name)) {
            this.method = value;
        } else if ("DOCUMENT_URI".equalsIgnoreCase(name)) {
            this.path = value;
        } else if ("QUERY_STRING".equalsIgnoreCase(name)) {
            this.query = value;
        } else if ("SERVER_PROTOCOL".equalsIgnoreCase(name)) {
            this.version = value;
        } else {
            this.processField(field);
        }
    }

    private void processField(HttpField field) {
        HttpField httpField = this.convertHeader(field);
        if (httpField != null) {
            this.fields.add(httpField);
            if (HttpHeader.HOST.is(httpField.getName())) {
                this.hostPort = (HostPortHttpField)httpField;
            }
        }
    }

    public void onRequest() {
        Object uri = this.path;
        if (!StringUtil.isEmpty((String)this.query)) {
            uri = (String)uri + "?" + this.query;
        }
        this.onRequest(new MetaData.Request(this.method, HttpScheme.HTTP.asString(), this.hostPort, (String)uri, HttpVersion.fromString((String)this.version), (HttpFields)this.fields, Long.MIN_VALUE));
    }

    private HttpField convertHeader(HttpField field) {
        String name = field.getName();
        if (name.startsWith("HTTP_")) {
            String[] parts = name.split("_");
            StringBuilder httpName = new StringBuilder();
            for (int i = 1; i < parts.length; ++i) {
                if (i > 1) {
                    httpName.append("-");
                }
                String part = parts[i];
                httpName.append(Character.toUpperCase(part.charAt(0)));
                httpName.append(part.substring(1).toLowerCase(Locale.ENGLISH));
            }
            String headerName = httpName.toString();
            String value = field.getValue();
            if (HttpHeader.HOST.is(headerName)) {
                return new HostPortHttpField(value);
            }
            return new HttpField(headerName, value);
        }
        return null;
    }

    protected void dispatch() {
        this.dispatcher.dispatch();
    }

    public boolean onIdleTimeout(Throwable timeout) {
        boolean handle = this.doOnIdleTimeout(timeout);
        if (handle) {
            this.execute((Runnable)((Object)this));
        }
        return !handle;
    }

    private boolean doOnIdleTimeout(Throwable x) {
        boolean waitingForContent;
        boolean neverDispatched = this.getState().isIdle();
        HttpInput.Content normal = this.normalContent;
        boolean bl = waitingForContent = normal == null || normal.remaining() == 0;
        if ((waitingForContent || neverDispatched) && this.specialContent == null) {
            x.addSuppressed(new Throwable("HttpInput idle timeout"));
            this.specialContent = new HttpInput.ErrorContent(x);
            return this.getRequest().getHttpInput().onContentProducible();
        }
        return false;
    }

    public void recycle() {
        super.recycle();
        HttpInput.Content normal = this.normalContent;
        if (normal != null) {
            throw new AssertionError((Object)("unconsumed content: " + normal));
        }
        this.specialContent = null;
    }

    public void onCompleted() {
        super.onCompleted();
        HttpInput input = this.getRequest().getHttpInput();
        boolean consumed = input.consumeAll();
        this.connection.onCompleted(consumed);
    }

    private static class Dispatcher
    implements Runnable {
        private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
        private final Executor executor;
        private final Runnable runnable;

        private Dispatcher(Executor executor, Runnable runnable) {
            this.executor = executor;
            this.runnable = runnable;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void dispatch() {
            block5: while (true) {
                State current = this.state.get();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Dispatching, state={}", (Object)current);
                }
                switch (current) {
                    case IDLE: {
                        if (!this.state.compareAndSet(current, State.DISPATCH)) continue block5;
                        this.executor.execute(this);
                        return;
                    }
                    case DISPATCH: 
                    case EXECUTE: {
                        if (this.state.compareAndSet(current, State.SCHEDULE)) return;
                        continue block5;
                    }
                    case SCHEDULE: {
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            block5: while (true) {
                State current = this.state.get();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Running, state={}", (Object)current);
                }
                switch (current) {
                    case DISPATCH: {
                        if (!this.state.compareAndSet(current, State.EXECUTE)) continue block5;
                        this.runnable.run();
                        continue block5;
                    }
                    case EXECUTE: {
                        if (!this.state.compareAndSet(current, State.IDLE)) continue block5;
                        return;
                    }
                    case SCHEDULE: {
                        if (!this.state.compareAndSet(current, State.DISPATCH)) throw new IllegalStateException();
                        continue block5;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }

        private static enum State {
            IDLE,
            DISPATCH,
            EXECUTE,
            SCHEDULE;

        }
    }

    private class AsyncFillCallback
    implements Callback {
        private AsyncFillCallback() {
        }

        public void succeeded() {
            if (HttpChannelOverFCGI.this.getRequest().getHttpInput().onContentProducible()) {
                HttpChannelOverFCGI.this.handle();
            }
        }

        public void failed(Throwable x) {
            if (HttpChannelOverFCGI.this.failed(x)) {
                HttpChannelOverFCGI.this.handle();
            }
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    }
}

