/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server;

import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpChannelOverFCGI
extends HttpChannel {
    private static final Logger LOG = Log.getLogger(HttpChannelOverFCGI.class);
    private final HttpFields fields = new HttpFields();
    private final Dispatcher dispatcher;
    private String method;
    private String path;
    private String query;
    private String version;
    private HostPortHttpField hostPort;

    public HttpChannelOverFCGI(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransport transport) {
        super(connector, configuration, endPoint, transport);
        this.dispatcher = new Dispatcher((Executor)connector.getServer().getThreadPool(), (Runnable)((Object)this));
    }

    protected void header(HttpField field) {
        String name = field.getName();
        String value = field.getValue();
        this.getRequest().setAttribute(name, (Object)value);
        if ("REQUEST_METHOD".equalsIgnoreCase(name)) {
            this.method = value;
        } else if ("DOCUMENT_URI".equalsIgnoreCase(name)) {
            this.path = value;
        } else if ("QUERY_STRING".equalsIgnoreCase(name)) {
            this.query = value;
        } else if ("SERVER_PROTOCOL".equalsIgnoreCase(name)) {
            this.version = value;
        } else {
            this.processField(field);
        }
    }

    private void processField(HttpField field) {
        HttpField httpField = this.convertHeader(field);
        if (httpField != null) {
            this.fields.add(httpField);
            if (HttpHeader.HOST.is(httpField.getName())) {
                this.hostPort = (HostPortHttpField)httpField;
            }
        }
    }

    public void onRequest() {
        Object uri = this.path;
        if (!StringUtil.isEmpty((String)this.query)) {
            uri = (String)uri + "?" + this.query;
        }
        this.onRequest(new MetaData.Request(this.method, HttpScheme.HTTP.asString(), this.hostPort, (String)uri, HttpVersion.fromString((String)this.version), this.fields, Long.MIN_VALUE));
    }

    private HttpField convertHeader(HttpField field) {
        String name = field.getName();
        if (name.startsWith("HTTP_")) {
            String[] parts = name.split("_");
            StringBuilder httpName = new StringBuilder();
            for (int i = 1; i < parts.length; ++i) {
                if (i > 1) {
                    httpName.append("-");
                }
                String part = parts[i];
                httpName.append(Character.toUpperCase(part.charAt(0)));
                httpName.append(part.substring(1).toLowerCase(Locale.ENGLISH));
            }
            String headerName = httpName.toString();
            String value = field.getValue();
            if (HttpHeader.HOST.is(headerName)) {
                return new HostPortHttpField(value);
            }
            return new HttpField(headerName, value);
        }
        return null;
    }

    protected void dispatch() {
        this.dispatcher.dispatch();
    }

    private static class Dispatcher
    implements Runnable {
        private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
        private final Executor executor;
        private final Runnable runnable;

        private Dispatcher(Executor executor, Runnable runnable) {
            this.executor = executor;
            this.runnable = runnable;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void dispatch() {
            block5: while (true) {
                State current = this.state.get();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Dispatching, state={}", new Object[]{current});
                }
                switch (current) {
                    case IDLE: {
                        if (!this.state.compareAndSet(current, State.DISPATCH)) continue block5;
                        this.executor.execute(this);
                        return;
                    }
                    case DISPATCH: 
                    case EXECUTE: {
                        if (this.state.compareAndSet(current, State.SCHEDULE)) return;
                        continue block5;
                    }
                    case SCHEDULE: {
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            block5: while (true) {
                State current = this.state.get();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Running, state={}", new Object[]{current});
                }
                switch (current) {
                    case DISPATCH: {
                        if (!this.state.compareAndSet(current, State.EXECUTE)) continue block5;
                        this.runnable.run();
                        continue block5;
                    }
                    case EXECUTE: {
                        if (!this.state.compareAndSet(current, State.IDLE)) continue block5;
                        return;
                    }
                    case SCHEDULE: {
                        if (!this.state.compareAndSet(current, State.DISPATCH)) throw new IllegalStateException();
                        continue block5;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }

        private static enum State {
            IDLE,
            DISPATCH,
            EXECUTE,
            SCHEDULE;

        }
    }
}

