/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.generator;

import java.nio.ByteBuffer;
import java.util.Queue;
import org.eclipse.jetty.fcgi.generator.Generator;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Flusher {
    private static final Logger LOG = Log.getLogger(Flusher.class);
    private final Queue<Generator.Result> queue = new ConcurrentArrayQueue();
    private final IteratingCallback flushCallback = new FlushCallback();
    private final EndPoint endPoint;

    public Flusher(EndPoint endPoint) {
        this.endPoint = endPoint;
    }

    public void flush(Generator.Result ... results) {
        for (Generator.Result result : results) {
            this.queue.offer(result);
        }
        this.flushCallback.iterate();
    }

    public void shutdown() {
        this.flush(new ShutdownResult());
    }

    private class ShutdownResult
    extends Generator.Result {
        private ShutdownResult() {
            super(null, null);
        }

        @Override
        public void succeeded() {
            this.shutdown();
        }

        @Override
        public void failed(Throwable x) {
            this.shutdown();
        }

        private void shutdown() {
            LOG.debug("Shutting down {}", new Object[]{Flusher.this.endPoint});
            Flusher.this.endPoint.shutdownOutput();
        }
    }

    private class FlushCallback
    extends IteratingCallback {
        private Generator.Result active;

        private FlushCallback() {
        }

        protected IteratingCallback.Action process() throws Exception {
            Generator.Result result = (Generator.Result)Flusher.this.queue.poll();
            if (result == null) {
                return IteratingCallback.Action.IDLE;
            }
            Generator.Result other = (Generator.Result)Flusher.this.queue.poll();
            if (other != null) {
                result = result.join(other);
            }
            this.active = result;
            ByteBuffer[] buffers = result.getByteBuffers();
            Flusher.this.endPoint.write((Callback)this, buffers);
            return IteratingCallback.Action.SCHEDULED;
        }

        protected void completed() {
            throw new IllegalStateException();
        }

        public void succeeded() {
            if (this.active != null) {
                this.active.succeeded();
            }
            this.active = null;
            super.succeeded();
        }

        public void failed(Throwable x) {
            Generator.Result result;
            if (this.active != null) {
                this.active.failed(x);
            }
            this.active = null;
            while ((result = (Generator.Result)Flusher.this.queue.poll()) != null) {
                result.failed(x);
            }
            super.failed(x);
        }
    }
}

