/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.http;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.client.AbstractHttpClientTransport;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.fcgi.client.http.HttpConnectionOverFCGI;
import org.eclipse.jetty.fcgi.client.http.HttpDestinationOverFCGI;
import org.eclipse.jetty.fcgi.client.http.MultiplexHttpDestinationOverFCGI;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Promise;

public class HttpClientTransportOverFCGI
extends AbstractHttpClientTransport {
    private final boolean multiplexed;
    private final String scriptRoot;

    public HttpClientTransportOverFCGI(String scriptRoot) {
        this(Math.max(1, Runtime.getRuntime().availableProcessors() / 2), false, scriptRoot);
    }

    public HttpClientTransportOverFCGI(int selectors, boolean multiplexed, String scriptRoot) {
        super(selectors);
        this.multiplexed = multiplexed;
        this.scriptRoot = scriptRoot;
    }

    public boolean isMultiplexed() {
        return this.multiplexed;
    }

    public String getScriptRoot() {
        return this.scriptRoot;
    }

    public HttpDestination newHttpDestination(Origin origin) {
        return this.isMultiplexed() ? new MultiplexHttpDestinationOverFCGI(this.getHttpClient(), origin) : new HttpDestinationOverFCGI(this.getHttpClient(), origin);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        HttpConnectionOverFCGI connection = new HttpConnectionOverFCGI(endPoint, destination, this.isMultiplexed());
        LOG.debug("Created {}", new Object[]{connection});
        Promise promise = (Promise)context.get("http.connection.promise");
        promise.succeeded((Object)connection);
        return connection;
    }

    protected void customize(Request request, HttpFields fastCGIHeaders) {
        fastCGIHeaders.put("DOCUMENT_ROOT", this.getScriptRoot());
    }
}

