/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.parser.ClientParser;
import org.eclipse.jetty.fcgi.parser.HeaderParser;
import org.eclipse.jetty.fcgi.parser.StreamContentParser;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseContentParser
extends StreamContentParser {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseContentParser.class);
    private final Map<Integer, ResponseParser> parsers = new ConcurrentHashMap<Integer, ResponseParser>();
    private final ClientParser.Listener listener;

    public ResponseContentParser(HeaderParser headerParser, ClientParser.Listener listener) {
        super(headerParser, FCGI.StreamType.STD_OUT, listener);
        this.listener = listener;
    }

    @Override
    public void noContent() {
    }

    @Override
    protected boolean onContent(ByteBuffer buffer) {
        int request = this.getRequest();
        ResponseParser parser = this.parsers.get(request);
        if (parser == null) {
            parser = new ResponseParser(this.listener, request);
            this.parsers.put(request, parser);
        }
        return parser.parse(buffer);
    }

    @Override
    protected void end(int request) {
        super.end(request);
        this.parsers.remove(request);
    }

    private static enum State {
        HEADERS,
        CONTENT_MODE,
        RAW_CONTENT,
        HTTP_CONTENT;

    }

    private static class FCGIHttpParser
    extends HttpParser {
        private FCGIHttpParser(HttpParser.ResponseHandler handler) {
            super(handler, 66560, HttpCompliance.RFC7230);
            this.reset();
        }

        public void reset() {
            super.reset();
            this.setResponseStatus(200);
            this.setState(HttpParser.State.HEADER);
        }

        protected void setResponseStatus(int status) {
            super.setResponseStatus(status);
        }
    }

    private static class ResponseParser
    implements HttpParser.ResponseHandler {
        private final HttpFields fields = new HttpFields();
        private ClientParser.Listener listener;
        private final int request;
        private final FCGIHttpParser httpParser;
        private State state = State.HEADERS;
        private boolean seenResponseCode;
        private boolean stalled;

        private ResponseParser(ClientParser.Listener listener, int request) {
            this.listener = listener;
            this.request = request;
            this.httpParser = new FCGIHttpParser(this);
        }

        public boolean parse(ByteBuffer buffer) {
            int remaining = buffer.remaining();
            block6: while (remaining > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response {} {}, state {} {}", new Object[]{this.request, FCGI.StreamType.STD_OUT, this.state, buffer});
                }
                switch (this.state) {
                    case HEADERS: {
                        if (this.httpParser.parseNext(buffer)) {
                            this.state = State.CONTENT_MODE;
                            if (this.stalled) {
                                return true;
                            }
                        }
                        remaining = buffer.remaining();
                        continue block6;
                    }
                    case CONTENT_MODE: {
                        boolean rawContent = this.fields.size() == 0 || this.fields.get(HttpHeader.CONTENT_LENGTH) == null && this.fields.get(HttpHeader.TRANSFER_ENCODING) == null;
                        this.state = rawContent ? State.RAW_CONTENT : State.HTTP_CONTENT;
                        continue block6;
                    }
                    case RAW_CONTENT: {
                        if (this.notifyContent(buffer)) {
                            return true;
                        }
                        remaining = 0;
                        continue block6;
                    }
                    case HTTP_CONTENT: {
                        if (this.httpParser.parseNext(buffer)) {
                            return true;
                        }
                        remaining = buffer.remaining();
                        continue block6;
                    }
                }
                throw new IllegalStateException();
            }
            return false;
        }

        public void startResponse(HttpVersion version, int status, String reason) {
            throw new IllegalStateException();
        }

        public void parsedHeader(HttpField httpField) {
            block6: {
                try {
                    String name = httpField.getName();
                    if ("Status".equalsIgnoreCase(name)) {
                        if (!this.seenResponseCode) {
                            this.seenResponseCode = true;
                            String value = httpField.getValue();
                            String[] parts = value.split(" ");
                            String status = parts[0];
                            int code = Integer.parseInt(status);
                            this.httpParser.setResponseStatus(code);
                            String reason = parts.length > 1 ? value.substring(status.length()) : HttpStatus.getMessage((int)code);
                            this.notifyBegin(code, reason.trim());
                            this.notifyHeaders(this.fields);
                        }
                    } else {
                        this.fields.add(httpField);
                        if (this.seenResponseCode) {
                            this.notifyHeader(httpField);
                        }
                    }
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("Exception while invoking listener " + this.listener, x);
                }
            }
        }

        private void notifyBegin(int code, String reason) {
            block2: {
                try {
                    this.listener.onBegin(this.request, code, reason);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("Exception while invoking listener " + this.listener, x);
                }
            }
        }

        private void notifyHeader(HttpField httpField) {
            block2: {
                try {
                    this.listener.onHeader(this.request, httpField);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("Exception while invoking listener " + this.listener, x);
                }
            }
        }

        private void notifyHeaders(HttpFields fields) {
            if (fields != null) {
                for (HttpField field : fields) {
                    this.notifyHeader(field);
                }
            }
        }

        private boolean notifyHeaders() {
            try {
                return this.listener.onHeaders(this.request);
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Exception while invoking listener " + this.listener, x);
                }
                return false;
            }
        }

        public boolean headerComplete() {
            if (!this.seenResponseCode) {
                this.notifyBegin(200, "OK");
                this.notifyHeaders(this.fields);
            }
            this.stalled = this.notifyHeaders();
            return true;
        }

        public boolean content(ByteBuffer buffer) {
            return this.notifyContent(buffer);
        }

        private boolean notifyContent(ByteBuffer buffer) {
            try {
                return this.listener.onContent(this.request, FCGI.StreamType.STD_OUT, buffer);
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Exception while invoking listener " + this.listener, x);
                }
                return false;
            }
        }

        public boolean contentComplete() {
            return false;
        }

        public boolean messageComplete() {
            return false;
        }

        public void earlyEOF() {
            this.fail(new EOFException());
        }

        public void badMessage(BadMessageException failure) {
            this.fail((Throwable)failure);
        }

        protected void fail(Throwable failure) {
            block2: {
                try {
                    this.listener.onFailure(this.request, failure);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("Exception while invoking listener " + this.listener, x);
                }
            }
        }
    }
}

