/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.http;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.DuplexHttpDestination;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.fcgi.client.http.HttpConnectionOverFCGI;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="The FastCGI/1.0 client transport")
public class HttpClientTransportOverFCGI
extends AbstractConnectorHttpClientTransport {
    private final String scriptRoot;

    public HttpClientTransportOverFCGI(String scriptRoot) {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2), scriptRoot);
    }

    public HttpClientTransportOverFCGI(int selectors, String scriptRoot) {
        this(new ClientConnector(), scriptRoot);
        this.getClientConnector().setSelectors(selectors);
    }

    public HttpClientTransportOverFCGI(ClientConnector connector, String scriptRoot) {
        super(connector);
        this.scriptRoot = scriptRoot;
        this.setConnectionPoolFactory(destination -> {
            HttpClient httpClient = this.getHttpClient();
            int maxConnections = httpClient.getMaxConnectionsPerDestination();
            return new DuplexConnectionPool((Destination)destination, maxConnections, (Callback)destination);
        });
    }

    @ManagedAttribute(value="The scripts root directory", readonly=true)
    public String getScriptRoot() {
        return this.scriptRoot;
    }

    public HttpDestination.Key newDestinationKey(HttpRequest request, Origin origin) {
        return new HttpDestination.Key(origin, new HttpDestination.Protocol(List.of("fastcgi/1.1"), false));
    }

    public HttpDestination newHttpDestination(HttpDestination.Key key) {
        return new DuplexHttpDestination(this.getHttpClient(), key);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        Promise promise = (Promise)context.get("org.eclipse.jetty.client.connection.promise");
        HttpConnectionOverFCGI connection = this.newHttpConnection(endPoint, destination, (Promise<org.eclipse.jetty.client.api.Connection>)promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", new Object[]{connection});
        }
        return this.customize((Connection)connection, context);
    }

    protected HttpConnectionOverFCGI newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<org.eclipse.jetty.client.api.Connection> promise) {
        return new HttpConnectionOverFCGI(endPoint, destination, promise);
    }

    protected void customize(Request request, HttpFields fastCGIHeaders) {
        fastCGIHeaders.put("DOCUMENT_ROOT", this.getScriptRoot());
    }
}

