/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import java.io.File;
import java.lang.management.ManagementFactory;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;

public class OneWebAppWithJsp {
    public static void main(String[] args) throws Exception {
        Server server = new Server(8080);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean((Object)mbContainer);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        File warFile = new File("../../jetty-distribution/target/distribution/demo-base/webapps/test.war");
        if (!warFile.exists()) {
            throw new RuntimeException("Unable to find WAR File: " + warFile.getAbsolutePath());
        }
        webapp.setWar(warFile.getAbsolutePath());
        webapp.setExtractWAR(true);
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)server);
        classlist.addBefore("org.eclipse.jetty.webapp.JettyWebXmlConfiguration", new String[]{"org.eclipse.jetty.annotations.AnnotationConfiguration"});
        webapp.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/[^/]*servlet-api-[^/]*\\.jar$|.*/javax.servlet.jsp.jstl-.*\\.jar$|.*/[^/]*taglibs.*\\.jar$");
        server.setHandler((Handler)webapp);
        HashLoginService loginService = new HashLoginService();
        loginService.setName("Test Realm");
        loginService.setConfig("src/test/resources/realm.properties");
        server.addBean((Object)loginService);
        server.start();
        server.dumpStdErr();
        server.join();
    }
}

