/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.embedded.HelloHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.ajax.JSON;

public class ManyHandlers {
    public static void main(String[] args) throws Exception {
        Server server = new Server(8080);
        ParamHandler param = new ParamHandler();
        WelcomeWrapHandler wrapper = new WelcomeWrapHandler();
        HelloHandler hello = new HelloHandler();
        DefaultHandler dft = new DefaultHandler();
        File requestLogFile = File.createTempFile("demo", "log");
        NCSARequestLog ncsaLog = new NCSARequestLog(requestLogFile.getAbsolutePath());
        server.setRequestLog((RequestLog)ncsaLog);
        HandlerCollection handlers = new HandlerCollection();
        HandlerList list = new HandlerList();
        wrapper.setHandler((Handler)hello);
        list.setHandlers(new Handler[]{param, new GzipHandler()});
        handlers.setHandlers(new Handler[]{list, dft});
        server.setHandler((Handler)handlers);
        server.start();
        server.join();
    }

    public static class WelcomeWrapHandler
    extends HandlerWrapper {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            request.setAttribute("welcome", (Object)"Hello");
            super.handle(target, baseRequest, request, response);
        }
    }

    public static class ParamHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            Map params = request.getParameterMap();
            if (params.size() > 0) {
                response.setContentType("text/plain");
                response.getWriter().println(JSON.toString((Map)params));
                baseRequest.setHandled(true);
            }
        }
    }
}

