/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class WebSocketServer {
    public static void main(String[] args) throws Exception {
        Server server = new Server(8080);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder(EchoServlet.class), "/echo");
        server.start();
        context.dumpStdErr();
        server.join();
    }

    public static class EchoServlet
    extends WebSocketServlet {
        public void configure(WebSocketServletFactory factory) {
            factory.register(EchoSocket.class);
        }
    }

    @WebSocket
    public static class EchoSocket {
        @OnWebSocketMessage
        public void onMessage(Session session, String message) {
            session.getRemote().sendStringByFuture(message);
        }
    }
}

