/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import com.acme.MockDataSource;
import com.acme.MockUserTransaction;
import java.io.File;
import java.util.Properties;
import javax.transaction.UserTransaction;
import org.eclipse.jetty.jndi.factories.MailSessionReference;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.plus.jndi.Transaction;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;

public class ServerWithJNDI {
    public static void main(String[] args) throws Exception {
        Server server = new Server(8080);
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)server);
        classlist.addAfter("org.eclipse.jetty.webapp.FragmentConfiguration", new String[]{"org.eclipse.jetty.plus.webapp.EnvConfiguration", "org.eclipse.jetty.plus.webapp.PlusConfiguration"});
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        File warFile = new File("../../jetty-distribution/target/distribution/demo-base/webapps/test.war");
        webapp.setWar(warFile.getAbsolutePath());
        server.setHandler((Handler)webapp);
        new Transaction((UserTransaction)new MockUserTransaction());
        new EnvEntry((Object)server, "woggle", (Object)new Integer(4000), false);
        new EnvEntry((Object)webapp, "wiggle", (Object)new Double(100.0), true);
        MailSessionReference mailref = new MailSessionReference();
        mailref.setUser("CHANGE-ME");
        mailref.setPassword("CHANGE-ME");
        Properties props = new Properties();
        props.put("mail.smtp.auth", "false");
        props.put("mail.smtp.host", "CHANGE-ME");
        props.put("mail.from", "CHANGE-ME");
        props.put("mail.debug", "false");
        mailref.setProperties(props);
        new Resource((Object)webapp, "mail/Session", (Object)mailref);
        new Resource((Object)webapp, "jdbc/mydatasource", (Object)new MockDataSource());
        server.start();
        server.join();
    }
}

