/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ManyConnectors {
    public static void main(String[] args) throws Exception {
        Server server = new Server();
        SelectChannelConnector connector0 = new SelectChannelConnector();
        connector0.setPort(8080);
        connector0.setMaxIdleTime(5000);
        connector0.setName("connector 0");
        SelectChannelConnector connector1 = new SelectChannelConnector();
        connector1.setHost("127.0.0.1");
        connector1.setPort(8888);
        connector1.setName("connector 1");
        SocketConnector connector2 = new SocketConnector();
        connector2.setHost("127.0.0.2");
        connector2.setPort(8888);
        connector2.setThreadPool((ThreadPool)new QueuedThreadPool());
        connector2.setName("connector 2");
        server.setConnectors(new Connector[]{connector0, connector1, connector2});
        server.setHandler((Handler)new HelloHandler());
        server.start();
        server.join();
    }

    public static class HelloHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.setContentType("text/html");
            response.setStatus(200);
            response.getWriter().println("<h1>Hello OneHandler</h1>");
            response.getWriter().println("from " + ((Request)request).getConnection().getConnector().getName());
            ((Request)request).setHandled(true);
        }
    }
}

