/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.security;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.util.Set;
import org.eclipse.jetty.ee9.nested.Authentication;
import org.eclipse.jetty.ee9.security.ServerAuthException;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Server;

public interface Authenticator {
    public static final String BASIC_AUTH = "BASIC";
    public static final String FORM_AUTH = "FORM";
    public static final String DIGEST_AUTH = "DIGEST";
    public static final String CERT_AUTH = "CLIENT_CERT";
    public static final String CERT_AUTH2 = "CLIENT-CERT";
    public static final String SPNEGO_AUTH = "SPNEGO";
    public static final String NEGOTIATE_AUTH = "NEGOTIATE";
    public static final String OPENID_AUTH = "OPENID";

    public void setConfiguration(AuthConfiguration var1);

    public String getAuthMethod();

    public void prepareRequest(ServletRequest var1);

    public Authentication validateRequest(ServletRequest var1, ServletResponse var2, boolean var3) throws ServerAuthException;

    public boolean secureResponse(ServletRequest var1, ServletResponse var2, boolean var3, Authentication.User var4) throws ServerAuthException;

    public static interface Factory {
        public Authenticator getAuthenticator(Server var1, ServletContext var2, AuthConfiguration var3, IdentityService var4, LoginService var5);
    }

    public static interface AuthConfiguration {
        public String getAuthMethod();

        public String getRealmName();

        public String getInitParameter(String var1);

        public Set<String> getInitParameterNames();

        public LoginService getLoginService();

        public IdentityService getIdentityService();

        public boolean isSessionRenewedOnAuthentication();

        public int getSessionMaxInactiveIntervalOnAuthentication();
    }
}

