/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.security.openid;

import org.eclipse.jetty.ee9.security.Authenticator;
import org.eclipse.jetty.ee9.security.WrappedAuthConfiguration;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.openid.OpenIdConfiguration;
import org.eclipse.jetty.security.openid.OpenIdLoginService;

public class OpenIdAuthConfiguration
extends WrappedAuthConfiguration {
    private final OpenIdLoginService _openIdLoginService;

    public OpenIdAuthConfiguration(OpenIdConfiguration openIdConfiguration, Authenticator.AuthConfiguration authConfiguration) {
        super(authConfiguration);
        LoginService loginService = authConfiguration.getLoginService();
        if (loginService instanceof OpenIdLoginService) {
            this._openIdLoginService = (OpenIdLoginService)loginService;
        } else {
            this._openIdLoginService = new OpenIdLoginService(openIdConfiguration, loginService);
            if (loginService == null) {
                this._openIdLoginService.setIdentityService(authConfiguration.getIdentityService());
            }
        }
    }

    public LoginService getLoginService() {
        return this._openIdLoginService;
    }
}

