/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.maven.plugin;

import java.net.URI;
import org.eclipse.jetty.ee.WebAppClassLoader;
import org.eclipse.jetty.ee9.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.ee9.webapp.Configuration;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.ee9.webapp.WebInfConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenWebInfConfiguration
extends WebInfConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MavenWebInfConfiguration.class);

    public MavenWebInfConfiguration() {
        this.hide(new String[]{"org.apache.maven.", "org.codehaus.plexus.", "jakarta.enterprise.", "javax.decorator."});
    }

    public Class<? extends Configuration> replaces() {
        return WebInfConfiguration.class;
    }

    public void configure(WebAppContext context) throws Exception {
        Object object;
        MavenWebAppContext jwac = (MavenWebAppContext)context;
        if (jwac.getClassPathUris() != null && (object = context.getClassLoader()) instanceof WebAppClassLoader) {
            WebAppClassLoader loader = (WebAppClassLoader)object;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting up classpath ...");
            }
            for (URI uri : jwac.getClassPathUris()) {
                loader.addClassPath(uri.toASCIIString());
            }
        }
        super.configure(context);
    }
}

