/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.websocket.javax.server.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.websocket.server.PathParam;
import org.eclipse.jetty.websocket.core.exception.InvalidSignatureException;
import org.eclipse.jetty.websocket.core.util.InvokerUtils;

public class PathParamIdentifier
implements InvokerUtils.ParamIdentifier {
    public InvokerUtils.Arg getParamArg(Method method, Class<?> paramType, int idx) {
        Annotation[] annos = method.getParameterAnnotations()[idx];
        if (annos != null || annos.length > 0) {
            for (Annotation anno : annos) {
                if (!anno.annotationType().equals(PathParam.class)) continue;
                PathParamIdentifier.validateType(paramType);
                PathParam pathParam = (PathParam)anno;
                return new InvokerUtils.Arg(paramType, pathParam.value());
            }
        }
        return new InvokerUtils.Arg(paramType);
    }

    public static void validateType(Class<?> type) {
        if (!(String.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type))) {
            throw new InvalidSignatureException("Unsupported PathParam Type: " + String.valueOf(type));
        }
    }
}

