/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.websocket.javax.server.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.ee8.websocket.javax.common.ConfiguredEndpoint;
import org.eclipse.jetty.ee8.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.ee8.websocket.javax.common.JavaxWebSocketExtension;
import org.eclipse.jetty.ee8.websocket.javax.common.ServerEndpointConfigWrapper;
import org.eclipse.jetty.ee8.websocket.javax.server.internal.AnnotatedServerEndpointConfig;
import org.eclipse.jetty.ee8.websocket.javax.server.internal.JsrHandshakeRequest;
import org.eclipse.jetty.ee8.websocket.javax.server.internal.JsrHandshakeResponse;
import org.eclipse.jetty.ee8.websocket.javax.server.internal.PathParamServerEndpointConfig;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.WebSocketExtensionRegistry;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import org.eclipse.jetty.websocket.core.server.WebSocketCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaxWebSocketCreator
implements WebSocketCreator {
    public static final String PROP_REMOTE_ADDRESS = "javax.websocket.endpoint.remoteAddress";
    public static final String PROP_LOCAL_ADDRESS = "javax.websocket.endpoint.localAddress";
    public static final String PROP_LOCALES = "javax.websocket.upgrade.locales";
    private static final Logger LOG = LoggerFactory.getLogger(JavaxWebSocketCreator.class);
    private final JavaxWebSocketContainer containerScope;
    private final ServerEndpointConfig baseConfig;
    private final WebSocketExtensionRegistry extensionRegistry;

    public JavaxWebSocketCreator(JavaxWebSocketContainer containerScope, ServerEndpointConfig config, WebSocketExtensionRegistry extensionRegistry) {
        this.containerScope = containerScope;
        this.baseConfig = config;
        this.extensionRegistry = extensionRegistry;
    }

    public Object createWebSocket(ServerUpgradeRequest request, ServerUpgradeResponse response, Callback callback) {
        List requested;
        JsrHandshakeRequest jsrHandshakeRequest = new JsrHandshakeRequest(request);
        JsrHandshakeResponse jsrHandshakeResponse = new JsrHandshakeResponse(response);
        ServerEndpointConfigWrapper config = new ServerEndpointConfigWrapper(this.baseConfig){
            final Map<String, Object> userProperties;
            {
                this.userProperties = new HashMap<String, Object>(JavaxWebSocketCreator.this.baseConfig.getUserProperties());
            }

            public Map<String, Object> getUserProperties() {
                return this.userProperties;
            }
        };
        Map userProperties = config.getUserProperties();
        userProperties.put(PROP_LOCAL_ADDRESS, request.getConnectionMetaData().getLocalSocketAddress());
        userProperties.put(PROP_REMOTE_ADDRESS, request.getConnectionMetaData().getRemoteSocketAddress());
        userProperties.put(PROP_LOCALES, Request.getLocales((Request)request));
        ServerEndpointConfig.Configurator configurator = config.getConfigurator();
        if (!configurator.checkOrigin(request.getHeaders().get(HttpHeader.ORIGIN))) {
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)403, (String)"Origin mismatch");
            return null;
        }
        List supported = config.getSubprotocols();
        String subprotocol = configurator.getNegotiatedSubprotocol(supported, requested = request.getSubProtocols());
        if (StringUtil.isNotBlank((String)subprotocol)) {
            response.setAcceptedSubProtocol(subprotocol);
        }
        ArrayList<JavaxWebSocketExtension> installedExtensions = new ArrayList<JavaxWebSocketExtension>();
        for (Object extName : this.extensionRegistry.getAvailableExtensions().keySet()) {
            installedExtensions.add(new JavaxWebSocketExtension((String)extName));
        }
        ArrayList<JavaxWebSocketExtension> requestedExts = new ArrayList<JavaxWebSocketExtension>();
        for (ExtensionConfig reqCfg : request.getExtensions()) {
            requestedExts.add(new JavaxWebSocketExtension(reqCfg));
        }
        List usedExtensions = configurator.getNegotiatedExtensions(installedExtensions, requestedExts);
        ArrayList<ExtensionConfig> configs = new ArrayList<ExtensionConfig>();
        if (usedExtensions != null) {
            for (Extension used : usedExtensions) {
                ExtensionConfig ecfg = new ExtensionConfig(used.getName());
                for (Extension.Parameter param : used.getParameters()) {
                    ecfg.setParameter(param.getName(), param.getValue());
                }
                configs.add(ecfg);
            }
        }
        response.setExtensions(configs);
        PathSpec pathSpecObject = jsrHandshakeRequest.getRequestPathSpec();
        if (pathSpecObject instanceof UriTemplatePathSpec) {
            UriTemplatePathSpec pathSpec = (UriTemplatePathSpec)pathSpecObject;
            Map pathParams = pathSpec.getPathParams(Request.getPathInContext((Request)request));
            config = new PathParamServerEndpointConfig((ServerEndpointConfig)config, pathParams);
        } else {
            Map<String, String> pathParams = jsrHandshakeRequest.getPathParams();
            if (pathParams != null) {
                config = new PathParamServerEndpointConfig((ServerEndpointConfig)config, pathParams);
            }
        }
        configurator.modifyHandshake((ServerEndpointConfig)config, (HandshakeRequest)jsrHandshakeRequest, (HandshakeResponse)jsrHandshakeResponse);
        jsrHandshakeResponse.setHeaders(jsrHandshakeResponse.getHeaders());
        try {
            Class endpointClass = config.getEndpointClass();
            Object endpoint = config.getConfigurator().getEndpointInstance(endpointClass);
            return new ConfiguredEndpoint(endpoint, (EndpointConfig)config);
        }
        catch (Throwable x) {
            LOG.warn("Unable to create websocket: {}", (Object)config.getEndpointClass().getName(), (Object)x);
            callback.failed(x);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaxWebSocketCreator that = (JavaxWebSocketCreator)o;
        return Objects.equals(this.baseConfig, that.baseConfig);
    }

    public int hashCode() {
        return this.baseConfig != null ? this.baseConfig.hashCode() : 0;
    }

    public String toString() {
        return String.format("JsrCreator[%s%s]", this.baseConfig instanceof AnnotatedServerEndpointConfig ? "@" : "", this.baseConfig.getEndpointClass().getName());
    }
}

