/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.websocket.javax.common.decoders;

import java.lang.reflect.InvocationTargetException;
import javax.websocket.Decoder;
import javax.websocket.EndpointConfig;
import org.eclipse.jetty.ee8.websocket.javax.common.InitException;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(RegisteredDecoder.class);
    public final Class<? extends Decoder> decoder;
    public final Class<? extends Decoder> interfaceType;
    public final Class<?> objectType;
    public final boolean primitive;
    public final EndpointConfig config;
    private final WebSocketComponents components;
    private Decoder instance;

    public RegisteredDecoder(Class<? extends Decoder> decoder, Class<? extends Decoder> interfaceType, Class<?> objectType, EndpointConfig endpointConfig, WebSocketComponents components) {
        this(decoder, interfaceType, objectType, endpointConfig, components, false);
    }

    public RegisteredDecoder(Class<? extends Decoder> decoder, Class<? extends Decoder> interfaceType, Class<?> objectType, EndpointConfig endpointConfig, WebSocketComponents components, boolean primitive) {
        this.decoder = decoder;
        this.interfaceType = interfaceType;
        this.objectType = objectType;
        this.primitive = primitive;
        this.config = endpointConfig;
        this.components = components;
    }

    public boolean implementsInterface(Class<? extends Decoder> type) {
        return this.interfaceType.isAssignableFrom(type);
    }

    public boolean isType(Class<?> type) {
        return this.objectType.isAssignableFrom(type);
    }

    public <T extends Decoder> T getInstance() {
        if (this.instance == null) {
            try {
                this.instance = (Decoder)this.components.getObjectFactory().createInstance(this.decoder);
                this.instance.init(this.config);
                return (T)this.instance;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new InitException("Unable to init Decoder for type:" + this.decoder.getName(), e);
            }
        }
        return (T)this.instance;
    }

    public void destroyInstance() {
        if (this.instance != null) {
            try {
                this.instance.destroy();
            }
            catch (Throwable t) {
                LOG.warn("Error destroying Decoder", t);
            }
            this.instance = null;
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(RegisteredDecoder.class.getSimpleName());
        str.append('[').append(this.decoder.getName());
        str.append(',').append(this.interfaceType.getName());
        str.append(',').append(this.objectType.getName());
        if (this.primitive) {
            str.append(",PRIMITIVE");
        }
        str.append(']');
        return str.toString();
    }
}

