/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.osgi.boot.jsp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.osgi.ServerClasspathContributor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TLDServerClasspathContributor
implements ServerClasspathContributor {
    private static String JSTL_BUNDLE_CLASS = "org.apache.taglibs.standard.tag.el.core.WhenTag";

    public List<Bundle> getScannableBundles() {
        Bundle[] bundles;
        Bundle jstlBundle;
        if (!this.isJspAvailable()) {
            return Collections.emptyList();
        }
        ArrayList<Bundle> scannableBundles = new ArrayList<Bundle>();
        List<Object> bundleNames = Collections.emptyList();
        String tmp = System.getProperty("org.eclipse.jetty.osgi.tldbundles");
        if (tmp != null) {
            String[] names = tmp.split(", \n\r\t");
            bundleNames = Arrays.asList(names);
        }
        if ((jstlBundle = this.findJstlBundle()) != null) {
            scannableBundles.add(jstlBundle);
        }
        for (Bundle bundle : bundles = FrameworkUtil.getBundle(this.getClass()).getBundleContext().getBundles()) {
            if (!bundleNames.contains(bundle.getSymbolicName())) continue;
            scannableBundles.add(bundle);
        }
        return scannableBundles;
    }

    public boolean isJspAvailable() {
        try {
            this.getClass().getClassLoader().loadClass("org.apache.jasper.servlet.JspServlet");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Bundle findJstlBundle() {
        Class<?> jstlClass = null;
        try {
            jstlClass = this.getClass().getClassLoader().loadClass(JSTL_BUNDLE_CLASS);
            return FrameworkUtil.getBundle(jstlClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

